/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.reader;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import org.apache.drill.exec.vector.accessor.reader.AbstractScalarReader;
import org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import org.apache.drill.exec.vector.accessor.reader.OffsetVectorReader;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessors;

public abstract class BaseScalarReader
extends AbstractScalarReader {
    protected ColumnMetadata schema;
    protected VectorAccessor vectorAccessor;
    protected BufferAccessor bufferAccessor;

    public static AbstractScalarReader.ScalarObjectReader buildOptional(ColumnMetadata schema, VectorAccessor va, BaseScalarReader reader) {
        reader.bindVector(schema, VectorAccessors.nullableValuesAccessor(va));
        reader.bindNullState(new NullStateReaders.NullableIsSetVectorStateReader(va));
        return new AbstractScalarReader.ScalarObjectReader(reader);
    }

    public static AbstractScalarReader.ScalarObjectReader buildRequired(ColumnMetadata schema, VectorAccessor va, BaseScalarReader reader) {
        reader.bindVector(schema, va);
        reader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new AbstractScalarReader.ScalarObjectReader(reader);
    }

    public void bindVector(ColumnMetadata schema, VectorAccessor va) {
        this.schema = schema;
        this.vectorAccessor = va;
        this.bufferAccessor = this.bufferAccessor(va);
    }

    protected BufferAccessor bufferAccessor(VectorAccessor va) {
        return new VectorBufferAccessor(va);
    }

    @Override
    public void bindIndex(ColumnReaderIndex rowIndex) {
        super.bindIndex(rowIndex);
        this.vectorAccessor.bind(rowIndex);
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public void bindBuffer() {
        this.nullStateReader.bindBuffer();
    }

    public final DrillBuf buffer() {
        return this.bufferAccessor.buffer();
    }

    public static interface BufferAccessor {
        public DrillBuf buffer();
    }

    private static class VectorBufferAccessor
    implements BufferAccessor {
        private final VectorAccessor va;

        public VectorBufferAccessor(VectorAccessor va) {
            this.va = va;
        }

        @Override
        public DrillBuf buffer() {
            BaseDataValueVector vector = (BaseDataValueVector)this.va.vector();
            return vector.getBuffer();
        }
    }

    public static abstract class BaseVarWidthReader
    extends BaseScalarReader {
        protected OffsetVectorReader offsetsReader;

        @Override
        public void bindVector(ColumnMetadata schema, VectorAccessor va) {
            super.bindVector(schema, va);
            this.offsetsReader = new OffsetVectorReader(VectorAccessors.varWidthOffsetVectorAccessor(va));
        }

        @Override
        public void bindIndex(ColumnReaderIndex index) {
            super.bindIndex(index);
            this.offsetsReader.bindIndex(index);
        }

        @Override
        public void bindBuffer() {
            super.bindBuffer();
            this.offsetsReader.bindBuffer();
        }

        public final long getEntry() {
            return this.offsetsReader.getEntry();
        }
    }

    public static abstract class BaseFixedWidthReader
    extends BaseScalarReader {
        public abstract int width();

        public final int offsetIndex() {
            return this.vectorIndex.offset();
        }
    }
}

