/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.writer;

import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.accessor.ColumnWriter;
import org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import org.apache.drill.exec.vector.accessor.ObjectType;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriter;
import org.apache.drill.exec.vector.accessor.writer.WriterEvents;

public abstract class AbstractScalarWriterImpl
extends AbstractScalarWriter
implements WriterEvents {
    protected ColumnMetadata schema;
    protected ColumnWriterIndex vectorIndex;

    @Override
    public ObjectType type() {
        return ObjectType.SCALAR;
    }

    public void bindSchema(ColumnMetadata schema) {
        this.schema = schema;
    }

    @Override
    public void bindIndex(ColumnWriterIndex vectorIndex) {
        this.vectorIndex = vectorIndex;
    }

    @Override
    public int rowStartIndex() {
        return this.vectorIndex.rowStartIndex();
    }

    @Override
    public int writeIndex() {
        return this.vectorIndex.vectorIndex();
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    public abstract BaseDataValueVector vector();

    @Override
    public void startWrite() {
    }

    @Override
    public void startRow() {
    }

    @Override
    public void endArrayValue() {
    }

    @Override
    public void saveRow() {
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.startObject(this).attributeIdentity("vector", this.vector()).attribute("schema", this.vector().getField()).endObject();
    }

    public static class ScalarObjectWriter
    extends AbstractObjectWriter {
        private final AbstractScalarWriterImpl scalarWriter;

        public ScalarObjectWriter(AbstractScalarWriterImpl baseWriter) {
            this.scalarWriter = baseWriter;
        }

        @Override
        public ScalarWriter scalar() {
            return this.scalarWriter;
        }

        @Override
        public ColumnWriter writer() {
            return this.scalarWriter;
        }

        @Override
        public WriterEvents events() {
            return this.scalarWriter;
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("scalarWriter");
            this.scalarWriter.dump(format);
            format.endObject();
        }
    }
}

