/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.writer;

import org.apache.drill.exec.memory.BaseAllocator;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriterImpl;

public abstract class BaseVarWidthWriter
extends BaseScalarWriter {
    protected final OffsetVectorWriterImpl offsetsWriter;

    public BaseVarWidthWriter(UInt4Vector offsetVector) {
        this.offsetsWriter = new OffsetVectorWriterImpl(offsetVector);
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.offsetsWriter.bindIndex(index);
        super.bindIndex(index);
    }

    @Override
    public void startWrite() {
        this.setBuffer();
        this.offsetsWriter.startWrite();
    }

    @Override
    public void startRow() {
        this.offsetsWriter.startRow();
    }

    protected final int prepareWrite(int width) {
        this.fillEmpties();
        return this.writeOffset(width);
    }

    private final int writeOffset(int width) {
        int writeOffset = this.offsetsWriter.nextOffset;
        if (writeOffset + width < this.capacity) {
            return writeOffset;
        }
        this.resize(writeOffset + width);
        return this.offsetsWriter.nextOffset;
    }

    protected final int prepareAppend(int width) {
        return this.writeOffset(width);
    }

    @Override
    protected final void setBuffer() {
        this.drillBuf = this.vector().getBuffer();
        this.capacity = this.drillBuf.capacity();
    }

    private void resize(int size) {
        if (size <= this.capacity) {
            return;
        }
        if (size < 256) {
            size = 256;
        }
        if ((size = BaseAllocator.nextPowerOfTwo(size)) <= ValueVector.MAX_BUFFER_SIZE && this.canExpand(size - this.capacity)) {
            this.realloc(size);
        } else {
            this.overflowed();
        }
    }

    @Override
    public void skipNulls() {
    }

    @Override
    public void restartRow() {
        this.offsetsWriter.restartRow();
    }

    @Override
    public int lastWriteIndex() {
        return this.offsetsWriter.lastWriteIndex();
    }

    private void fillEmpties() {
        if (this.emptyValue == null) {
            return;
        }
        int fillCount = this.offsetsWriter.prepareFill() - this.offsetsWriter.lastWriteIndex - 1;
        if (fillCount == 0) {
            return;
        }
        int len = this.emptyValue.length;
        for (int i = 0; i < fillCount; ++i) {
            int writeOffset = this.writeOffset(len);
            this.drillBuf.setBytes(writeOffset, this.emptyValue, 0, len);
            this.offsetsWriter.fillOffset(writeOffset + len);
        }
    }

    @Override
    public final void preRollover() {
        this.vector().getBuffer().writerIndex(this.offsetsWriter.rowStartOffset());
        this.offsetsWriter.preRollover();
    }

    @Override
    public void postRollover() {
        this.setBuffer();
        this.offsetsWriter.postRollover();
    }

    @Override
    public final void endWrite() {
        this.fillEmpties();
        this.vector().getBuffer().writerIndex(this.offsetsWriter.nextOffset());
        this.offsetsWriter.endWrite();
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("offsetsWriter");
        this.offsetsWriter.dump(format);
        format.endObject();
    }
}

