/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.writer;

import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.ColumnReader;
import org.apache.drill.exec.vector.accessor.ScalarReader;
import org.apache.drill.exec.vector.accessor.ValueType;
import org.apache.drill.exec.vector.accessor.writer.AbstractFixedWidthWriter;

public class BitColumnWriter
extends AbstractFixedWidthWriter {
    private final BitVector vector;
    private final BitVector.Mutator mutator;
    private int defaultValue;

    public BitColumnWriter(ValueVector vector) {
        this.vector = (BitVector)vector;
        this.mutator = this.vector.getMutator();
    }

    @Override
    public BaseDataValueVector vector() {
        return this.vector;
    }

    @Override
    public int width() {
        return 1;
    }

    @Override
    public ValueType valueType() {
        return ValueType.BOOLEAN;
    }

    protected int prepareWrite() {
        int writeIndex = this.vectorIndex.vectorIndex();
        this.prepareWrite(writeIndex);
        this.lastWriteIndex = writeIndex;
        return writeIndex;
    }

    private void prepareWrite(int writeIndex) {
        int byteIndex = writeIndex >> 3;
        if (byteIndex >= this.capacity) {
            this.resize(byteIndex);
        }
        if (this.lastWriteIndex + 1 < writeIndex) {
            this.fillEmpties(writeIndex);
        }
        this.lastWriteIndex = writeIndex;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.prepareWrite(valueCount);
        this.mutator.setValueCount(valueCount);
    }

    @Override
    protected final void fillEmpties(int writeIndex) {
        for (int dest = this.lastWriteIndex + 1; dest < writeIndex; ++dest) {
            this.mutator.set(dest, this.defaultValue);
        }
    }

    @Override
    public final void setBoolean(boolean value) {
        this.mutator.set(this.prepareWrite(), value ? 1 : 0);
        this.vectorIndex.nextElement();
    }

    @Override
    public void setInt(int value) {
        this.setBoolean(value != 0);
    }

    @Override
    public void setValue(Object value) {
        this.setInt((Integer)value);
    }

    @Override
    public final void setDefaultValue(Object value) {
        this.defaultValue = (Boolean)value != false ? 1 : 0;
    }

    @Override
    public void copy(ColumnReader from) {
        ScalarReader source = (ScalarReader)from;
        this.setInt(source.getInt());
    }
}

