/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex;

import io.netty.buffer.DrillBuf;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.BasicTypeHelper;
import org.apache.drill.exec.expr.holders.ComplexHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.util.CallBack;
import org.apache.drill.exec.util.JsonStringHashMap;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.SchemaChangeCallBack;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.apache.drill.exec.vector.complex.RepeatedMapVector;
import org.apache.drill.exec.vector.complex.impl.SingleMapReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Ordering;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;

public class MapVector
extends AbstractMapVector {
    public static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.MAP);
    private final SingleMapReaderImpl reader = new SingleMapReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int valueCount;
    private transient MapTransferPair ephPair;
    private transient RepeatedMapVector.MapSingleCopier ephPair2;

    public MapVector(String path, BufferAllocator allocator, CallBack callBack) {
        this(MaterializedField.create(path, TYPE), allocator, callBack);
    }

    public MapVector(MaterializedField field, BufferAllocator allocator, CallBack callBack) {
        super(field, allocator, callBack);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    public void copyFromSafe(int fromIndex, int thisIndex, MapVector from) {
        if (this.ephPair == null || this.ephPair.from != from) {
            this.ephPair = (MapTransferPair)from.makeTransferPair(this);
        }
        this.ephPair.copyValueSafe(fromIndex, thisIndex);
    }

    public void copyFromSafe(int fromSubIndex, int thisIndex, RepeatedMapVector from) {
        if (this.ephPair2 == null || this.ephPair2.from != from) {
            this.ephPair2 = from.makeSingularCopier(this);
        }
        this.ephPair2.copySafe(fromSubIndex, thisIndex);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (MapVector)from);
    }

    @Override
    protected boolean supportsDirectRead() {
        return true;
    }

    public Iterator<String> fieldNameIterator() {
        return this.getChildFieldNames().iterator();
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        for (ValueVector v : this) {
            v.setInitialCapacity(numRecords);
        }
    }

    @Override
    public int getBufferSize() {
        if (this.valueCount == 0 || this.size() == 0) {
            return 0;
        }
        long buffer = 0L;
        for (ValueVector v : this) {
            buffer += (long)v.getBufferSize();
        }
        return (int)buffer;
    }

    @Override
    public int getAllocatedSize() {
        int size = 0;
        for (ValueVector v : this) {
            size += v.getAllocatedSize();
        }
        return size;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        long bufferSize = 0L;
        for (ValueVector v : this) {
            bufferSize += (long)v.getBufferSizeFor(valueCount);
        }
        return (int)bufferSize;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        return super.getBuffers(clear);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new MapTransferPair(this, this.getField().getName(), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new MapTransferPair(this, (MapVector)to);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new MapTransferPair(this, ref, allocator);
    }

    @Override
    public int getValueCapacity() {
        if (this.size() == 0) {
            return 0;
        }
        Ordering<ValueVector> natural = new Ordering<ValueVector>(){

            @Override
            public int compare(@Nullable ValueVector left, @Nullable ValueVector right) {
                return Ints.compare(Preconditions.checkNotNull(left).getValueCapacity(), Preconditions.checkNotNull(right).getValueCapacity());
            }
        };
        return natural.min(this.getChildren()).getValueCapacity();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buf) {
        List<UserBitShared.SerializedField> fields = metadata.getChildList();
        this.valueCount = metadata.getValueCount();
        int bufOffset = 0;
        for (UserBitShared.SerializedField child : fields) {
            MaterializedField fieldDef = MaterializedField.create(child);
            ValueVector vector = this.getChild(fieldDef.getName());
            if (vector == null) {
                vector = BasicTypeHelper.getNewVector(fieldDef, this.allocator);
                this.putChild(fieldDef.getName(), vector);
            }
            if (child.getValueCount() == 0) {
                vector.clear();
            } else {
                vector.load(child, buf.slice(bufOffset, child.getBufferLength()));
            }
            bufOffset += child.getBufferLength();
        }
        assert (bufOffset == buf.writerIndex());
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        UserBitShared.SerializedField.Builder b = this.getField().getAsBuilder().setBufferLength(this.getBufferSize()).setValueCount(this.valueCount);
        for (ValueVector v : this.getChildren()) {
            b.addChild(v.getMetadata());
        }
        return b.build();
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    public ValueVector getVectorById(int id) {
        return this.getChildByOrdinal(id);
    }

    public void setMapValueCount(int valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public void clear() {
        for (ValueVector v : this.getChildren()) {
            v.clear();
        }
        this.valueCount = 0;
    }

    @Override
    public void close() {
        Collection<ValueVector> vectors = this.getChildren();
        for (ValueVector v : vectors) {
            v.close();
        }
        vectors.clear();
        this.valueCount = 0;
        super.close();
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exchange(ValueVector other) {
        super.exchange(other);
        MapVector otherMap = (MapVector)other;
        int temp = otherMap.valueCount;
        otherMap.valueCount = this.valueCount;
        this.valueCount = temp;
    }

    protected static class MapTransferPair
    implements TransferPair {
        private final TransferPair[] pairs;
        private final MapVector from;
        private final MapVector to;

        public MapTransferPair(MapVector from, String path, BufferAllocator allocator) {
            this(from, new MapVector(MaterializedField.create(path, TYPE), allocator, (CallBack)new SchemaChangeCallBack()), false);
        }

        public MapTransferPair(MapVector from, MapVector to) {
            this(from, to, true);
        }

        protected MapTransferPair(MapVector from, MapVector to, boolean allocate) {
            this.from = from;
            this.to = to;
            this.pairs = new TransferPair[from.size()];
            this.to.ephPair = null;
            this.to.ephPair2 = null;
            int i = 0;
            for (String child : from.getChildFieldNames()) {
                int preSize = to.size();
                ValueVector vector = from.getChild(child);
                if (vector == null) continue;
                Object newVector = to.addOrGet(child, vector.getField().getType(), vector.getClass());
                if (allocate && to.size() != preSize) {
                    newVector.allocateNew();
                }
                this.pairs[i++] = vector.makeTransferPair((ValueVector)newVector);
            }
        }

        @Override
        public void transfer() {
            for (TransferPair p : this.pairs) {
                p.transfer();
            }
            this.to.valueCount = this.from.valueCount;
            this.from.clear();
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            for (TransferPair p : this.pairs) {
                p.copyValueSafe(from, to);
            }
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            for (TransferPair p : this.pairs) {
                p.splitAndTransfer(startIndex, length);
            }
            this.to.getMutator().setValueCount(length);
        }
    }

    public class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public Object getObject(int index) {
            JsonStringHashMap<String, Object> vv = new JsonStringHashMap<String, Object>();
            for (String child : MapVector.this.getChildFieldNames()) {
                Object value;
                ValueVector v = MapVector.this.getChild(child);
                if (v == null || index >= v.getAccessor().getValueCount() || (value = v.getAccessor().getObject(index)) == null) continue;
                vv.put(child, value);
            }
            return vv;
        }

        public void get(int index, ComplexHolder holder) {
            MapVector.this.reader.setPosition(index);
            holder.reader = MapVector.this.reader;
        }

        @Override
        public int getValueCount() {
            return MapVector.this.valueCount;
        }
    }

    public class Mutator
    extends BaseValueVector.BaseMutator {
        @Override
        public void setValueCount(int valueCount) {
            for (ValueVector v : MapVector.this.getChildren()) {
                v.getMutator().setValueCount(valueCount);
            }
            MapVector.this.setMapValueCount(valueCount);
        }

        @Override
        public void reset() {
        }

        @Override
        public void generateTestData(int values) {
        }
    }
}

