/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.fn;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekableBAIS
extends ByteArrayInputStream
implements Seekable,
PositionedReadable {
    static final Logger logger = LoggerFactory.getLogger(SeekableBAIS.class);

    public SeekableBAIS(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public SeekableBAIS(byte[] buf) {
        super(buf);
    }

    public void seek(long pos) throws IOException {
        if (pos > (long)this.buf.length) {
            throw new EOFException();
        }
        this.pos = (int)pos;
        this.count = this.buf.length - (int)pos;
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (position >= (long)this.buf.length) {
            throw new IllegalArgumentException();
        }
        if (position + (long)length > (long)this.buf.length) {
            throw new IllegalArgumentException();
        }
        if (length > buffer.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.buf, (int)position, buffer, offset, length);
        return length;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.read(position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.read(position, buffer, 0, buffer.length);
    }
}

