/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.Decimal18Holder;
import org.apache.drill.exec.expr.holders.NullableDecimal18Holder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.Decimal18Vector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.Decimal18WriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal18Writer;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class Decimal18ReaderImpl
extends AbstractFieldReader {
    private final Decimal18Vector vector;

    public Decimal18ReaderImpl(Decimal18Vector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(Decimal18Writer writer) {
        Decimal18WriterImpl impl = (Decimal18WriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        Decimal18WriterImpl impl = (Decimal18WriterImpl)writer.decimal18(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(Decimal18Holder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public void read(ValueHolder h) {
        if (h instanceof Decimal18Holder) {
            this.read((Decimal18Holder)h);
        } else {
            this.read((NullableDecimal18Holder)h);
        }
    }

    @Override
    public void read(NullableDecimal18Holder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public BigDecimal readBigDecimal() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

