/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.NullableFloat8Holder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;

public class Float8HolderReaderImpl
extends AbstractFieldReader {
    private Float8Holder holder;

    public Float8HolderReaderImpl(Float8Holder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return Float8Holder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(Float8Holder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableFloat8Holder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Double readDouble() {
        Double value = new Double(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        Double value = new Double(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(Float8Writer writer) {
        if (this.isSet()) {
            writer.writeFloat8(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        Float8Writer impl = writer.float8(name);
        if (this.isSet()) {
            impl.writeFloat8(this.holder.value);
        }
    }
}

