/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalDayHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalDayWriter;
import org.joda.time.Period;

public class IntervalDayHolderReaderImpl
extends AbstractFieldReader {
    private IntervalDayHolder holder;

    public IntervalDayHolderReaderImpl(IntervalDayHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return IntervalDayHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntervalDayHolder h) {
        h.days = this.holder.days;
        h.milliseconds = this.holder.milliseconds;
    }

    @Override
    public void read(NullableIntervalDayHolder h) {
        h.days = this.holder.days;
        h.milliseconds = this.holder.milliseconds;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Period readPeriod() {
        Period p = new Period();
        return p.plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        Period p = new Period();
        return p.plusDays(this.holder.days).plusMillis(this.holder.milliseconds);
    }

    @Override
    public void copyAsValue(IntervalDayWriter writer) {
        if (this.isSet()) {
            writer.writeIntervalDay(this.holder.days, this.holder.milliseconds);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        IntervalDayWriter impl = writer.intervalDay(name);
        if (this.isSet()) {
            impl.writeIntervalDay(this.holder.days, this.holder.milliseconds);
        }
    }
}

