/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;

public class NullableDateHolderReaderImpl
extends AbstractFieldReader {
    private NullableDateHolder holder;

    public NullableDateHolderReaderImpl(NullableDateHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableDateHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(DateHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableDateHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDate readLocalDate() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public void copyAsValue(DateWriter writer) {
        if (this.isSet()) {
            writer.writeDate(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        DateWriter impl = writer.date(name);
        if (this.isSet()) {
            impl.writeDate(this.holder.value);
        }
    }
}

