/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.BasicTypeHelper;
import org.apache.drill.exec.expr.holders.Decimal38DenseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal38DenseHolder;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal38DenseWriter;

public class NullableDecimal38DenseHolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimal38DenseHolder holder;

    public NullableDecimal38DenseHolderReaderImpl(NullableDecimal38DenseHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(Decimal38DenseHolder h) {
        h.start = this.holder.start;
        h.buffer = this.holder.buffer;
        h.precision = this.holder.precision;
        h.scale = this.holder.scale;
    }

    @Override
    public void read(NullableDecimal38DenseHolder h) {
        h.start = this.holder.start;
        h.buffer = this.holder.buffer;
        h.precision = this.holder.precision;
        h.scale = this.holder.scale;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 4, this.holder.scale, 38, 16);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 4, this.holder.scale, 38, 16);
    }

    @Override
    public void copyAsValue(Decimal38DenseWriter writer) {
        if (this.isSet()) {
            writer.writeDecimal38Dense(this.holder.start, this.holder.buffer, this.holder.precision, this.holder.scale);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        Decimal38DenseWriter impl = writer.decimal38Dense(name);
        if (this.isSet()) {
            impl.writeDecimal38Dense(this.holder.start, this.holder.buffer, this.holder.precision, this.holder.scale);
        }
    }
}

