/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.joda.time.Period;

public class NullableIntervalReaderImpl
extends AbstractFieldReader {
    private final NullableIntervalVector vector;

    public NullableIntervalReaderImpl(NullableIntervalVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(IntervalWriter writer) {
        NullableIntervalWriterImpl impl = (NullableIntervalWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableIntervalWriterImpl impl = (NullableIntervalWriterImpl)writer.interval(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(ValueHolder h) {
        this.read((NullableIntervalHolder)h);
    }

    @Override
    public void read(NullableIntervalHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Period readPeriod() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

