/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedBitVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.RepeatedBitWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;

public class RepeatedBitReaderImpl
extends AbstractFieldReader {
    private final RepeatedBitVector vector;

    public RepeatedBitReaderImpl(RepeatedBitVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(BitWriter writer) {
        RepeatedBitWriterImpl impl = (RepeatedBitWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedBitWriterImpl impl = (RepeatedBitWriterImpl)writer.list(name).bit();
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public int size() {
        return this.vector.getAccessor().getInnerValueCountAt(this.idx());
    }

    @Override
    public void read(int arrayIndex, BitHolder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public void read(int arrayIndex, NullableBitHolder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public Boolean readBoolean(int arrayIndex) {
        return this.vector.getAccessor().getSingleObject(this.idx(), arrayIndex);
    }

    @Override
    public List<Object> readObject() {
        return (List)this.vector.getAccessor().getObject(this.idx());
    }
}

