/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.BasicTypeHelper;
import org.apache.drill.exec.expr.holders.NullableDecimal38SparseHolder;
import org.apache.drill.exec.expr.holders.RepeatedDecimal38SparseHolder;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.RepeatedDecimal38SparseWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal38SparseWriter;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedDecimal38SparseHolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimal38SparseHolder holder = new NullableDecimal38SparseHolder();
    private int index = -1;
    private RepeatedDecimal38SparseHolder repeatedHolder;

    public RepeatedDecimal38SparseHolderReaderImpl(RepeatedDecimal38SparseHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public BigDecimal readBigDecimal(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        BigDecimal value = this.readBigDecimal();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromSparse(this.holder.buffer, this.holder.start, 6, this.holder.scale);
    }

    @Override
    public Object readObject() {
        ArrayList<BigDecimal> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromSparse(this.holder.buffer, this.holder.start, 6, this.holder.scale);
    }

    @Override
    public void copyAsValue(Decimal38SparseWriter writer) {
        RepeatedDecimal38SparseWriterImpl impl = (RepeatedDecimal38SparseWriterImpl)writer;
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedDecimal38SparseWriterImpl impl = (RepeatedDecimal38SparseWriterImpl)writer.list(name).decimal38Sparse();
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }
}

