/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.NullableFloat4Holder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedFloat4Vector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.RepeatedFloat4WriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;

public class RepeatedFloat4ReaderImpl
extends AbstractFieldReader {
    private final RepeatedFloat4Vector vector;

    public RepeatedFloat4ReaderImpl(RepeatedFloat4Vector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(Float4Writer writer) {
        RepeatedFloat4WriterImpl impl = (RepeatedFloat4WriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedFloat4WriterImpl impl = (RepeatedFloat4WriterImpl)writer.list(name).float4();
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public int size() {
        return this.vector.getAccessor().getInnerValueCountAt(this.idx());
    }

    @Override
    public void read(int arrayIndex, Float4Holder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public void read(int arrayIndex, NullableFloat4Holder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public Float readFloat(int arrayIndex) {
        return this.vector.getAccessor().getSingleObject(this.idx(), arrayIndex);
    }

    @Override
    public List<Object> readObject() {
        return (List)this.vector.getAccessor().getObject(this.idx());
    }
}

