/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedIntervalVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.RepeatedIntervalWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.joda.time.Period;

public class RepeatedIntervalReaderImpl
extends AbstractFieldReader {
    private final RepeatedIntervalVector vector;

    public RepeatedIntervalReaderImpl(RepeatedIntervalVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(IntervalWriter writer) {
        RepeatedIntervalWriterImpl impl = (RepeatedIntervalWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedIntervalWriterImpl impl = (RepeatedIntervalWriterImpl)writer.list(name).interval();
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public int size() {
        return this.vector.getAccessor().getInnerValueCountAt(this.idx());
    }

    @Override
    public void read(int arrayIndex, IntervalHolder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public void read(int arrayIndex, NullableIntervalHolder h) {
        this.vector.getAccessor().get(this.idx(), arrayIndex, h);
    }

    @Override
    public Period readPeriod(int arrayIndex) {
        return this.vector.getAccessor().getSingleObject(this.idx(), arrayIndex);
    }

    @Override
    public List<Object> readObject() {
        return (List)this.vector.getAccessor().getObject(this.idx());
    }
}

