/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedIntervalVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedIntervalWriterImpl
extends AbstractFieldWriter {
    private final RepeatedIntervalVector.Mutator mutator;
    final RepeatedIntervalVector vector;

    public RepeatedIntervalWriterImpl(RepeatedIntervalVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(IntervalHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableIntervalHolder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeInterval(int months, int days, int milliseconds) {
        this.mutator.addSafe(this.idx(), months, days, milliseconds);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void setPosition(int idx) {
        super.setPosition(idx);
        if (idx >= this.vector.getAccessor().getValueCount()) {
            this.mutator.startNewValue(idx);
        }
    }
}

