/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.util.ArrayList;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableUInt1Holder;
import org.apache.drill.exec.expr.holders.RepeatedUInt1Holder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.RepeatedUInt1WriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.UInt1Writer;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedUInt1HolderReaderImpl
extends AbstractFieldReader {
    private NullableUInt1Holder holder = new NullableUInt1Holder();
    private int index = -1;
    private RepeatedUInt1Holder repeatedHolder;

    public RepeatedUInt1HolderReaderImpl(RepeatedUInt1Holder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return RepeatedUInt1Holder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public Byte readByte(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        Byte value = this.readByte();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public Byte readByte() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        ArrayList<Byte> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        Byte value = new Byte(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(UInt1Writer writer) {
        RepeatedUInt1WriterImpl impl = (RepeatedUInt1WriterImpl)writer;
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        RepeatedUInt1WriterImpl impl = (RepeatedUInt1WriterImpl)writer.list(name).uInt1();
        impl.vector.getMutator().setSafe(impl.idx(), this.repeatedHolder);
    }
}

