/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.util.Text;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.impl.AbstractRepeatedMapReaderImpl;
import org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import org.apache.drill.exec.vector.complex.reader.BaseReader;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class SingleDictReaderImpl
extends AbstractRepeatedMapReaderImpl<DictVector>
implements BaseReader.DictReader {
    public static final int NOT_FOUND = -1;

    public SingleDictReaderImpl(DictVector vector) {
        super(vector);
    }

    @Override
    public FieldReader reader(String name) {
        assert (DictVector.fieldNames.contains(name));
        return super.reader(name);
    }

    @Override
    public int find(String key) {
        Object typifiedKey = this.getAppropriateKey(key);
        return this.find(typifiedKey);
    }

    @Override
    public int find(int key) {
        Object typifiedKey = this.getAppropriateKey(key);
        return this.find(typifiedKey);
    }

    @Override
    public int find(Object key) {
        int start = ((DictVector)this.vector).getOffsetVector().getAccessor().get(this.idx());
        int end = ((DictVector)this.vector).getOffsetVector().getAccessor().get(this.idx() + 1);
        int index = -1;
        ValueVector keys = ((DictVector)this.vector).getKeys();
        for (int i = end - 1; i >= start; --i) {
            Object keyValue = keys.getAccessor().getObject(i);
            if (!keyValue.equals(key)) continue;
            index = i;
            break;
        }
        return index;
    }

    private Object getAppropriateKey(int key) {
        TypeProtos.MajorType keyType = ((DictVector)this.vector).getKeyType();
        switch (keyType.getMinorType()) {
            case SMALLINT: {
                return (short)key;
            }
            case INT: {
                return key;
            }
            case BIGINT: {
                return (long)key;
            }
            case FLOAT4: {
                return Float.valueOf(key);
            }
            case FLOAT8: {
                return (double)key;
            }
            case VARDECIMAL: {
                return BigDecimal.valueOf(key).setScale(keyType.getScale(), RoundingMode.HALF_UP);
            }
            case BIT: {
                return key != 0;
            }
            case VARCHAR: 
            case VARBINARY: {
                return new Text(String.valueOf(key));
            }
        }
        String message = String.format("Unknown value %d for key of type %s", key, keyType.getMinorType().toString());
        throw new IllegalArgumentException(message);
    }

    private Object getAppropriateKey(String key) {
        TypeProtos.MajorType keyType = ((DictVector)this.vector).getKeyType();
        switch (keyType.getMinorType()) {
            case VARCHAR: 
            case VARBINARY: {
                return new Text(key);
            }
            case BIT: {
                return Boolean.valueOf(key);
            }
            case SMALLINT: {
                return Short.valueOf(key);
            }
            case INT: {
                return Integer.valueOf(key);
            }
            case BIGINT: {
                return Long.valueOf(key);
            }
            case FLOAT4: {
                return Float.valueOf(key);
            }
            case FLOAT8: {
                return Double.valueOf(key);
            }
            case VARDECIMAL: {
                return BigDecimal.valueOf(Double.valueOf(key)).setScale(keyType.getScale(), RoundingMode.HALF_UP);
            }
            case TIMESTAMP: {
                return DateUtility.parseBest(key);
            }
            case DATE: {
                return DateUtility.parseLocalDate(key);
            }
            case TIME: {
                return DateUtility.parseLocalTime(key);
            }
        }
        String message = String.format("Unknown value %s for key of type %s", key, keyType.getMinorType().toString());
        throw new IllegalArgumentException(message);
    }

    @Override
    public void read(String key, ValueHolder holder) {
        Object typifiedKey = this.getAppropriateKey(key);
        this.read(typifiedKey, holder);
    }

    @Override
    public void read(int key, ValueHolder holder) {
        Object typifiedKey = this.getAppropriateKey(key);
        this.read(typifiedKey, holder);
    }

    @Override
    public void read(Object key, ValueHolder holder) {
        if (this.isEmpty()) {
            return;
        }
        int index = this.find(key);
        FieldReader valueReader = this.reader("value");
        valueReader.setPosition(index);
        if (index != -1) {
            valueReader.read(holder);
        }
    }

    @Override
    public void setPosition(int index) {
        if (index == -1) {
            for (FieldReader reader : this.fields.values()) {
                reader.setPosition(index);
            }
        }
        super.setPosition(index);
    }

    @Override
    public void copyAsValue(BaseWriter.DictWriter writer) {
        if (this.isEmpty()) {
            return;
        }
        ComplexCopier.copy(this, (FieldWriter)writer);
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        ComplexCopier.copy(this, (FieldWriter)writer.dict());
    }

    @Override
    public String getTypeString() {
        StringBuilder sb = new StringBuilder(super.getTypeString());
        if (((DictVector)this.vector).getKeyType() != null && ((DictVector)this.vector).getValueType() != null) {
            sb.append('<').append(((DictVector)this.vector).getKeyType().getMinorType().name()).append(',').append(((DictVector)this.vector).getValueType().getMinorType().name()).append('>');
        }
        return sb.toString();
    }

    @Override
    public TypeProtos.MinorType getVectorType() {
        return ((DictVector)this.vector).getField().getType().getMinorType();
    }
}

