/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;

public class SingleListReaderImpl
extends AbstractFieldReader {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.LIST);
    private final String name;
    private final AbstractContainerVector container;
    private FieldReader reader;

    public SingleListReaderImpl(String name, AbstractContainerVector container) {
        this.name = name;
        this.container = container;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        if (this.reader != null) {
            this.reader.setPosition(index);
        }
    }

    @Override
    public Object readObject() {
        return this.reader.readObject();
    }

    @Override
    public FieldReader reader() {
        if (this.reader == null) {
            this.reader = this.container.getChild(this.name).getReader();
            this.setPosition(this.idx());
        }
        return this.reader;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        throw new UnsupportedOperationException("Generic list copying not yet supported.  Please resolve to typed list.");
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        throw new UnsupportedOperationException("Generic list copying not yet supported.  Please resolve to typed list.");
    }
}

