/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.time.LocalTime;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.TimeVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.TimeWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.TimeWriter;

public class TimeReaderImpl
extends AbstractFieldReader {
    private final TimeVector vector;

    public TimeReaderImpl(TimeVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(TimeWriter writer) {
        TimeWriterImpl impl = (TimeWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        TimeWriterImpl impl = (TimeWriterImpl)writer.time(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(TimeHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public void read(ValueHolder h) {
        if (h instanceof TimeHolder) {
            this.read((TimeHolder)h);
        } else {
            this.read((NullableTimeHolder)h);
        }
    }

    @Override
    public void read(NullableTimeHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public LocalTime readLocalTime() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

