/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.NullableTimeHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.TimeVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class TimeWriterImpl
extends AbstractFieldWriter {
    private final TimeVector.Mutator mutator;
    final TimeVector vector;

    public TimeWriterImpl(TimeVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(TimeHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableTimeHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeTime(int value) {
        this.mutator.setSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

