/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import io.netty.buffer.DrillBuf;
import java.util.List;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.complex.UnionVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import org.apache.drill.exec.vector.complex.impl.NullableBigIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableBitWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDateWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableFloat4WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableFloat8WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalDayWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalYearWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableSmallIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTimeStampWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTimeWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTinyIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt1WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt2WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt4WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt8WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVar16CharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarBinaryWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarCharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarDecimalWriterImpl;
import org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import org.apache.drill.exec.vector.complex.impl.UnionListWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal18Writer;
import org.apache.drill.exec.vector.complex.writer.Decimal28DenseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal28SparseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal38DenseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal38SparseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal9Writer;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalDayWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalYearWriter;
import org.apache.drill.exec.vector.complex.writer.SmallIntWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.drill.exec.vector.complex.writer.TimeWriter;
import org.apache.drill.exec.vector.complex.writer.TinyIntWriter;
import org.apache.drill.exec.vector.complex.writer.UInt1Writer;
import org.apache.drill.exec.vector.complex.writer.UInt2Writer;
import org.apache.drill.exec.vector.complex.writer.UInt4Writer;
import org.apache.drill.exec.vector.complex.writer.UInt8Writer;
import org.apache.drill.exec.vector.complex.writer.Var16CharWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class UnionWriter
extends AbstractFieldWriter
implements FieldWriter {
    protected UnionVector data;
    private BaseWriter.MapWriter mapWriter;
    private UnionListWriter listWriter;
    private List<BaseWriter> writers = Lists.newArrayList();
    private TinyIntWriter tinyIntWriter;
    private UInt1Writer uInt1Writer;
    private UInt2Writer uInt2Writer;
    private SmallIntWriter smallIntWriter;
    private IntWriter intWriter;
    private UInt4Writer uInt4Writer;
    private Float4Writer float4Writer;
    private TimeWriter timeWriter;
    private IntervalYearWriter intervalYearWriter;
    private BigIntWriter bigIntWriter;
    private UInt8Writer uInt8Writer;
    private Float8Writer float8Writer;
    private DateWriter dateWriter;
    private TimeStampWriter timeStampWriter;
    private IntervalDayWriter intervalDayWriter;
    private IntervalWriter intervalWriter;
    private VarBinaryWriter varBinaryWriter;
    private VarCharWriter varCharWriter;
    private Var16CharWriter var16CharWriter;
    private VarDecimalWriter varDecimalWriter;
    private BitWriter bitWriter;

    public UnionWriter(BufferAllocator allocator) {
        super(null);
    }

    public UnionWriter(UnionVector vector) {
        super(null);
        this.data = vector;
    }

    public UnionWriter(UnionVector vector, FieldWriter parent) {
        super(null);
        this.data = vector;
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        for (BaseWriter writer : this.writers) {
            writer.setPosition(index);
        }
    }

    @Override
    public void start() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().start();
    }

    @Override
    public void end() {
        this.getMapWriter().end();
    }

    @Override
    public void startList() {
        this.getListWriter().startList();
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
    }

    @Override
    public void endList() {
        this.getListWriter().endList();
    }

    private BaseWriter.MapWriter getMapWriter() {
        if (this.mapWriter == null) {
            this.mapWriter = new SingleMapWriter(this.data.getMap(), null, true);
            this.mapWriter.setPosition(this.idx());
            this.writers.add(this.mapWriter);
        }
        return this.mapWriter;
    }

    public BaseWriter.MapWriter asMap() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        return this.getMapWriter();
    }

    private BaseWriter.ListWriter getListWriter() {
        if (this.listWriter == null) {
            this.listWriter = new UnionListWriter(this.data.getList());
            this.listWriter.setPosition(this.idx());
            this.writers.add(this.listWriter);
        }
        return this.listWriter;
    }

    public BaseWriter.ListWriter asList() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        return this.getListWriter();
    }

    private TinyIntWriter getTinyIntWriter() {
        if (this.tinyIntWriter == null) {
            this.tinyIntWriter = new NullableTinyIntWriterImpl(this.data.getTinyIntVector(), null);
            this.tinyIntWriter.setPosition(this.idx());
            this.writers.add(this.tinyIntWriter);
        }
        return this.tinyIntWriter;
    }

    public TinyIntWriter asTinyInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TINYINT);
        return this.getTinyIntWriter();
    }

    @Override
    public void write(TinyIntHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TINYINT);
        this.getTinyIntWriter().setPosition(this.idx());
        this.getTinyIntWriter().writeTinyInt(holder.value);
    }

    @Override
    public void writeTinyInt(byte value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TINYINT);
        this.getTinyIntWriter().setPosition(this.idx());
        this.getTinyIntWriter().writeTinyInt(value);
    }

    private UInt1Writer getUInt1Writer() {
        if (this.uInt1Writer == null) {
            this.uInt1Writer = new NullableUInt1WriterImpl(this.data.getUInt1Vector(), null);
            this.uInt1Writer.setPosition(this.idx());
            this.writers.add(this.uInt1Writer);
        }
        return this.uInt1Writer;
    }

    public UInt1Writer asUInt1() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT1);
        return this.getUInt1Writer();
    }

    @Override
    public void write(UInt1Holder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT1);
        this.getUInt1Writer().setPosition(this.idx());
        this.getUInt1Writer().writeUInt1(holder.value);
    }

    @Override
    public void writeUInt1(byte value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT1);
        this.getUInt1Writer().setPosition(this.idx());
        this.getUInt1Writer().writeUInt1(value);
    }

    private UInt2Writer getUInt2Writer() {
        if (this.uInt2Writer == null) {
            this.uInt2Writer = new NullableUInt2WriterImpl(this.data.getUInt2Vector(), null);
            this.uInt2Writer.setPosition(this.idx());
            this.writers.add(this.uInt2Writer);
        }
        return this.uInt2Writer;
    }

    public UInt2Writer asUInt2() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT2);
        return this.getUInt2Writer();
    }

    @Override
    public void write(UInt2Holder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT2);
        this.getUInt2Writer().setPosition(this.idx());
        this.getUInt2Writer().writeUInt2(holder.value);
    }

    @Override
    public void writeUInt2(char value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT2);
        this.getUInt2Writer().setPosition(this.idx());
        this.getUInt2Writer().writeUInt2(value);
    }

    private SmallIntWriter getSmallIntWriter() {
        if (this.smallIntWriter == null) {
            this.smallIntWriter = new NullableSmallIntWriterImpl(this.data.getSmallIntVector(), null);
            this.smallIntWriter.setPosition(this.idx());
            this.writers.add(this.smallIntWriter);
        }
        return this.smallIntWriter;
    }

    public SmallIntWriter asSmallInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.SMALLINT);
        return this.getSmallIntWriter();
    }

    @Override
    public void write(SmallIntHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.SMALLINT);
        this.getSmallIntWriter().setPosition(this.idx());
        this.getSmallIntWriter().writeSmallInt(holder.value);
    }

    @Override
    public void writeSmallInt(short value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.SMALLINT);
        this.getSmallIntWriter().setPosition(this.idx());
        this.getSmallIntWriter().writeSmallInt(value);
    }

    private IntWriter getIntWriter() {
        if (this.intWriter == null) {
            this.intWriter = new NullableIntWriterImpl(this.data.getIntVector(), null);
            this.intWriter.setPosition(this.idx());
            this.writers.add(this.intWriter);
        }
        return this.intWriter;
    }

    public IntWriter asInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INT);
        return this.getIntWriter();
    }

    @Override
    public void write(IntHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INT);
        this.getIntWriter().setPosition(this.idx());
        this.getIntWriter().writeInt(holder.value);
    }

    @Override
    public void writeInt(int value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INT);
        this.getIntWriter().setPosition(this.idx());
        this.getIntWriter().writeInt(value);
    }

    private UInt4Writer getUInt4Writer() {
        if (this.uInt4Writer == null) {
            this.uInt4Writer = new NullableUInt4WriterImpl(this.data.getUInt4Vector(), null);
            this.uInt4Writer.setPosition(this.idx());
            this.writers.add(this.uInt4Writer);
        }
        return this.uInt4Writer;
    }

    public UInt4Writer asUInt4() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT4);
        return this.getUInt4Writer();
    }

    @Override
    public void write(UInt4Holder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT4);
        this.getUInt4Writer().setPosition(this.idx());
        this.getUInt4Writer().writeUInt4(holder.value);
    }

    @Override
    public void writeUInt4(int value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT4);
        this.getUInt4Writer().setPosition(this.idx());
        this.getUInt4Writer().writeUInt4(value);
    }

    private Float4Writer getFloat4Writer() {
        if (this.float4Writer == null) {
            this.float4Writer = new NullableFloat4WriterImpl(this.data.getFloat4Vector(), null);
            this.float4Writer.setPosition(this.idx());
            this.writers.add(this.float4Writer);
        }
        return this.float4Writer;
    }

    public Float4Writer asFloat4() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.FLOAT4);
        return this.getFloat4Writer();
    }

    @Override
    public void write(Float4Holder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.FLOAT4);
        this.getFloat4Writer().setPosition(this.idx());
        this.getFloat4Writer().writeFloat4(holder.value);
    }

    @Override
    public void writeFloat4(float value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.FLOAT4);
        this.getFloat4Writer().setPosition(this.idx());
        this.getFloat4Writer().writeFloat4(value);
    }

    private TimeWriter getTimeWriter() {
        if (this.timeWriter == null) {
            this.timeWriter = new NullableTimeWriterImpl(this.data.getTimeVector(), null);
            this.timeWriter.setPosition(this.idx());
            this.writers.add(this.timeWriter);
        }
        return this.timeWriter;
    }

    public TimeWriter asTime() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TIME);
        return this.getTimeWriter();
    }

    @Override
    public void write(TimeHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TIME);
        this.getTimeWriter().setPosition(this.idx());
        this.getTimeWriter().writeTime(holder.value);
    }

    @Override
    public void writeTime(int value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TIME);
        this.getTimeWriter().setPosition(this.idx());
        this.getTimeWriter().writeTime(value);
    }

    private IntervalYearWriter getIntervalYearWriter() {
        if (this.intervalYearWriter == null) {
            this.intervalYearWriter = new NullableIntervalYearWriterImpl(this.data.getIntervalYearVector(), null);
            this.intervalYearWriter.setPosition(this.idx());
            this.writers.add(this.intervalYearWriter);
        }
        return this.intervalYearWriter;
    }

    public IntervalYearWriter asIntervalYear() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVALYEAR);
        return this.getIntervalYearWriter();
    }

    @Override
    public void write(IntervalYearHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVALYEAR);
        this.getIntervalYearWriter().setPosition(this.idx());
        this.getIntervalYearWriter().writeIntervalYear(holder.value);
    }

    @Override
    public void writeIntervalYear(int value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVALYEAR);
        this.getIntervalYearWriter().setPosition(this.idx());
        this.getIntervalYearWriter().writeIntervalYear(value);
    }

    private BigIntWriter getBigIntWriter() {
        if (this.bigIntWriter == null) {
            this.bigIntWriter = new NullableBigIntWriterImpl(this.data.getBigIntVector(), null);
            this.bigIntWriter.setPosition(this.idx());
            this.writers.add(this.bigIntWriter);
        }
        return this.bigIntWriter;
    }

    public BigIntWriter asBigInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.BIGINT);
        return this.getBigIntWriter();
    }

    @Override
    public void write(BigIntHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.BIGINT);
        this.getBigIntWriter().setPosition(this.idx());
        this.getBigIntWriter().writeBigInt(holder.value);
    }

    @Override
    public void writeBigInt(long value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.BIGINT);
        this.getBigIntWriter().setPosition(this.idx());
        this.getBigIntWriter().writeBigInt(value);
    }

    private UInt8Writer getUInt8Writer() {
        if (this.uInt8Writer == null) {
            this.uInt8Writer = new NullableUInt8WriterImpl(this.data.getUInt8Vector(), null);
            this.uInt8Writer.setPosition(this.idx());
            this.writers.add(this.uInt8Writer);
        }
        return this.uInt8Writer;
    }

    public UInt8Writer asUInt8() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT8);
        return this.getUInt8Writer();
    }

    @Override
    public void write(UInt8Holder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT8);
        this.getUInt8Writer().setPosition(this.idx());
        this.getUInt8Writer().writeUInt8(holder.value);
    }

    @Override
    public void writeUInt8(long value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.UINT8);
        this.getUInt8Writer().setPosition(this.idx());
        this.getUInt8Writer().writeUInt8(value);
    }

    private Float8Writer getFloat8Writer() {
        if (this.float8Writer == null) {
            this.float8Writer = new NullableFloat8WriterImpl(this.data.getFloat8Vector(), null);
            this.float8Writer.setPosition(this.idx());
            this.writers.add(this.float8Writer);
        }
        return this.float8Writer;
    }

    public Float8Writer asFloat8() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.FLOAT8);
        return this.getFloat8Writer();
    }

    @Override
    public void write(Float8Holder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.FLOAT8);
        this.getFloat8Writer().setPosition(this.idx());
        this.getFloat8Writer().writeFloat8(holder.value);
    }

    @Override
    public void writeFloat8(double value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.FLOAT8);
        this.getFloat8Writer().setPosition(this.idx());
        this.getFloat8Writer().writeFloat8(value);
    }

    private DateWriter getDateWriter() {
        if (this.dateWriter == null) {
            this.dateWriter = new NullableDateWriterImpl(this.data.getDateVector(), null);
            this.dateWriter.setPosition(this.idx());
            this.writers.add(this.dateWriter);
        }
        return this.dateWriter;
    }

    public DateWriter asDate() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.DATE);
        return this.getDateWriter();
    }

    @Override
    public void write(DateHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.DATE);
        this.getDateWriter().setPosition(this.idx());
        this.getDateWriter().writeDate(holder.value);
    }

    @Override
    public void writeDate(long value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.DATE);
        this.getDateWriter().setPosition(this.idx());
        this.getDateWriter().writeDate(value);
    }

    private TimeStampWriter getTimeStampWriter() {
        if (this.timeStampWriter == null) {
            this.timeStampWriter = new NullableTimeStampWriterImpl(this.data.getTimeStampVector(), null);
            this.timeStampWriter.setPosition(this.idx());
            this.writers.add(this.timeStampWriter);
        }
        return this.timeStampWriter;
    }

    public TimeStampWriter asTimeStamp() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TIMESTAMP);
        return this.getTimeStampWriter();
    }

    @Override
    public void write(TimeStampHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TIMESTAMP);
        this.getTimeStampWriter().setPosition(this.idx());
        this.getTimeStampWriter().writeTimeStamp(holder.value);
    }

    @Override
    public void writeTimeStamp(long value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.TIMESTAMP);
        this.getTimeStampWriter().setPosition(this.idx());
        this.getTimeStampWriter().writeTimeStamp(value);
    }

    private IntervalDayWriter getIntervalDayWriter() {
        if (this.intervalDayWriter == null) {
            this.intervalDayWriter = new NullableIntervalDayWriterImpl(this.data.getIntervalDayVector(), null);
            this.intervalDayWriter.setPosition(this.idx());
            this.writers.add(this.intervalDayWriter);
        }
        return this.intervalDayWriter;
    }

    public IntervalDayWriter asIntervalDay() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVALDAY);
        return this.getIntervalDayWriter();
    }

    @Override
    public void write(IntervalDayHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVALDAY);
        this.getIntervalDayWriter().setPosition(this.idx());
        this.getIntervalDayWriter().writeIntervalDay(holder.days, holder.milliseconds);
    }

    @Override
    public void writeIntervalDay(int days, int milliseconds) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVALDAY);
        this.getIntervalDayWriter().setPosition(this.idx());
        this.getIntervalDayWriter().writeIntervalDay(days, milliseconds);
    }

    private IntervalWriter getIntervalWriter() {
        if (this.intervalWriter == null) {
            this.intervalWriter = new NullableIntervalWriterImpl(this.data.getIntervalVector(), null);
            this.intervalWriter.setPosition(this.idx());
            this.writers.add(this.intervalWriter);
        }
        return this.intervalWriter;
    }

    public IntervalWriter asInterval() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVAL);
        return this.getIntervalWriter();
    }

    @Override
    public void write(IntervalHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVAL);
        this.getIntervalWriter().setPosition(this.idx());
        this.getIntervalWriter().writeInterval(holder.months, holder.days, holder.milliseconds);
    }

    @Override
    public void writeInterval(int months, int days, int milliseconds) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.INTERVAL);
        this.getIntervalWriter().setPosition(this.idx());
        this.getIntervalWriter().writeInterval(months, days, milliseconds);
    }

    private VarBinaryWriter getVarBinaryWriter() {
        if (this.varBinaryWriter == null) {
            this.varBinaryWriter = new NullableVarBinaryWriterImpl(this.data.getVarBinaryVector(), null);
            this.varBinaryWriter.setPosition(this.idx());
            this.writers.add(this.varBinaryWriter);
        }
        return this.varBinaryWriter;
    }

    public VarBinaryWriter asVarBinary() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARBINARY);
        return this.getVarBinaryWriter();
    }

    @Override
    public void write(VarBinaryHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARBINARY);
        this.getVarBinaryWriter().setPosition(this.idx());
        this.getVarBinaryWriter().writeVarBinary(holder.start, holder.end, holder.buffer);
    }

    @Override
    public void writeVarBinary(int start, int end, DrillBuf buffer) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARBINARY);
        this.getVarBinaryWriter().setPosition(this.idx());
        this.getVarBinaryWriter().writeVarBinary(start, end, buffer);
    }

    private VarCharWriter getVarCharWriter() {
        if (this.varCharWriter == null) {
            this.varCharWriter = new NullableVarCharWriterImpl(this.data.getVarCharVector(), null);
            this.varCharWriter.setPosition(this.idx());
            this.writers.add(this.varCharWriter);
        }
        return this.varCharWriter;
    }

    public VarCharWriter asVarChar() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARCHAR);
        return this.getVarCharWriter();
    }

    @Override
    public void write(VarCharHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARCHAR);
        this.getVarCharWriter().setPosition(this.idx());
        this.getVarCharWriter().writeVarChar(holder.start, holder.end, holder.buffer);
    }

    @Override
    public void writeVarChar(int start, int end, DrillBuf buffer) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARCHAR);
        this.getVarCharWriter().setPosition(this.idx());
        this.getVarCharWriter().writeVarChar(start, end, buffer);
    }

    private Var16CharWriter getVar16CharWriter() {
        if (this.var16CharWriter == null) {
            this.var16CharWriter = new NullableVar16CharWriterImpl(this.data.getVar16CharVector(), null);
            this.var16CharWriter.setPosition(this.idx());
            this.writers.add(this.var16CharWriter);
        }
        return this.var16CharWriter;
    }

    public Var16CharWriter asVar16Char() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VAR16CHAR);
        return this.getVar16CharWriter();
    }

    @Override
    public void write(Var16CharHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VAR16CHAR);
        this.getVar16CharWriter().setPosition(this.idx());
        this.getVar16CharWriter().writeVar16Char(holder.start, holder.end, holder.buffer);
    }

    @Override
    public void writeVar16Char(int start, int end, DrillBuf buffer) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VAR16CHAR);
        this.getVar16CharWriter().setPosition(this.idx());
        this.getVar16CharWriter().writeVar16Char(start, end, buffer);
    }

    private VarDecimalWriter getVarDecimalWriter() {
        if (this.varDecimalWriter == null) {
            this.varDecimalWriter = new NullableVarDecimalWriterImpl(this.data.getVarDecimalVector(), null);
            this.varDecimalWriter.setPosition(this.idx());
            this.writers.add(this.varDecimalWriter);
        }
        return this.varDecimalWriter;
    }

    public VarDecimalWriter asVarDecimal() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARDECIMAL);
        return this.getVarDecimalWriter();
    }

    @Override
    public void write(VarDecimalHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARDECIMAL);
        this.getVarDecimalWriter().setPosition(this.idx());
        this.getVarDecimalWriter().writeVarDecimal(holder.start, holder.end, holder.buffer, holder.precision, holder.scale);
    }

    @Override
    public void writeVarDecimal(int start, int end, DrillBuf buffer, int precision, int scale) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.VARDECIMAL);
        this.getVarDecimalWriter().setPosition(this.idx());
        this.getVarDecimalWriter().writeVarDecimal(start, end, buffer, precision, scale);
    }

    private BitWriter getBitWriter() {
        if (this.bitWriter == null) {
            this.bitWriter = new NullableBitWriterImpl(this.data.getBitVector(), null);
            this.bitWriter.setPosition(this.idx());
            this.writers.add(this.bitWriter);
        }
        return this.bitWriter;
    }

    public BitWriter asBit() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.BIT);
        return this.getBitWriter();
    }

    @Override
    public void write(BitHolder holder) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.BIT);
        this.getBitWriter().setPosition(this.idx());
        this.getBitWriter().writeBit(holder.value);
    }

    @Override
    public void writeBit(int value) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.BIT);
        this.getBitWriter().setPosition(this.idx());
        this.getBitWriter().writeBit(value);
    }

    @Override
    public void writeNull() {
    }

    @Override
    public BaseWriter.MapWriter map() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().map();
    }

    @Override
    public BaseWriter.DictWriter dict() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().dict();
    }

    @Override
    public BaseWriter.ListWriter list() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().list();
    }

    @Override
    public BaseWriter.ListWriter list(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().list(name);
    }

    @Override
    public BaseWriter.MapWriter map(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().map(name);
    }

    @Override
    public TinyIntWriter tinyInt(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().tinyInt(name);
    }

    @Override
    public TinyIntWriter tinyInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().tinyInt();
    }

    @Override
    public UInt1Writer uInt1(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().uInt1(name);
    }

    @Override
    public UInt1Writer uInt1() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().uInt1();
    }

    @Override
    public UInt2Writer uInt2(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().uInt2(name);
    }

    @Override
    public UInt2Writer uInt2() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().uInt2();
    }

    @Override
    public SmallIntWriter smallInt(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().smallInt(name);
    }

    @Override
    public SmallIntWriter smallInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().smallInt();
    }

    @Override
    public IntWriter integer(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().integer(name);
    }

    @Override
    public IntWriter integer() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().integer();
    }

    @Override
    public UInt4Writer uInt4(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().uInt4(name);
    }

    @Override
    public UInt4Writer uInt4() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().uInt4();
    }

    @Override
    public Float4Writer float4(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().float4(name);
    }

    @Override
    public Float4Writer float4() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().float4();
    }

    @Override
    public TimeWriter time(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().time(name);
    }

    @Override
    public TimeWriter time() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().time();
    }

    @Override
    public IntervalYearWriter intervalYear(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().intervalYear(name);
    }

    @Override
    public IntervalYearWriter intervalYear() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().intervalYear();
    }

    @Override
    public Decimal9Writer decimal9(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().decimal9(name);
    }

    @Override
    public Decimal9Writer decimal9() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().decimal9();
    }

    @Override
    public BigIntWriter bigInt(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().bigInt(name);
    }

    @Override
    public BigIntWriter bigInt() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().bigInt();
    }

    @Override
    public UInt8Writer uInt8(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().uInt8(name);
    }

    @Override
    public UInt8Writer uInt8() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().uInt8();
    }

    @Override
    public Float8Writer float8(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().float8(name);
    }

    @Override
    public Float8Writer float8() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().float8();
    }

    @Override
    public DateWriter date(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().date(name);
    }

    @Override
    public DateWriter date() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().date();
    }

    @Override
    public TimeStampWriter timeStamp(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().timeStamp(name);
    }

    @Override
    public TimeStampWriter timeStamp() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().timeStamp();
    }

    @Override
    public Decimal18Writer decimal18(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().decimal18(name);
    }

    @Override
    public Decimal18Writer decimal18() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().decimal18();
    }

    @Override
    public IntervalDayWriter intervalDay(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().intervalDay(name);
    }

    @Override
    public IntervalDayWriter intervalDay() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().intervalDay();
    }

    @Override
    public IntervalWriter interval(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().interval(name);
    }

    @Override
    public IntervalWriter interval() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().interval();
    }

    @Override
    public Decimal28DenseWriter decimal28Dense(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().decimal28Dense(name);
    }

    @Override
    public Decimal28DenseWriter decimal28Dense() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().decimal28Dense();
    }

    @Override
    public Decimal38DenseWriter decimal38Dense(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().decimal38Dense(name);
    }

    @Override
    public Decimal38DenseWriter decimal38Dense() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().decimal38Dense();
    }

    @Override
    public Decimal38SparseWriter decimal38Sparse(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().decimal38Sparse(name);
    }

    @Override
    public Decimal38SparseWriter decimal38Sparse() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().decimal38Sparse();
    }

    @Override
    public Decimal28SparseWriter decimal28Sparse(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().decimal28Sparse(name);
    }

    @Override
    public Decimal28SparseWriter decimal28Sparse() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().decimal28Sparse();
    }

    @Override
    public VarBinaryWriter varBinary(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().varBinary(name);
    }

    @Override
    public VarBinaryWriter varBinary() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().varBinary();
    }

    @Override
    public VarCharWriter varChar(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().varChar(name);
    }

    @Override
    public VarCharWriter varChar() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().varChar();
    }

    @Override
    public Var16CharWriter var16Char(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().var16Char(name);
    }

    @Override
    public Var16CharWriter var16Char() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().var16Char();
    }

    @Override
    public VarDecimalWriter varDecimal(String name, int precision, int scale) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().varDecimal(name, precision, scale);
    }

    @Override
    public VarDecimalWriter varDecimal(int precision, int scale) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().varDecimal(precision, scale);
    }

    @Override
    public BitWriter bit(String name) {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.MAP);
        this.getMapWriter().setPosition(this.idx());
        return this.getMapWriter().bit(name);
    }

    @Override
    public BitWriter bit() {
        this.data.getMutator().setType(this.idx(), TypeProtos.MinorType.LIST);
        this.getListWriter().setPosition(this.idx());
        return this.getListWriter().bit();
    }

    @Override
    public void allocate() {
        this.data.allocateNew();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void close() throws Exception {
        this.data.close();
    }

    @Override
    public MaterializedField getField() {
        return this.data.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.data.getValueCapacity();
    }
}

