/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.util.Text;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;

public class VarCharHolderReaderImpl
extends AbstractFieldReader {
    private VarCharHolder holder;

    public VarCharHolderReaderImpl(VarCharHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return VarCharHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(VarCharHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
    }

    @Override
    public void read(NullableVarCharHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Text readText() {
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        Text text = new Text();
        text.set(value);
        return text;
    }

    @Override
    public void copyAsValue(VarCharWriter writer) {
        if (this.isSet()) {
            writer.writeVarChar(this.holder.start, this.holder.end, this.holder.buffer);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        VarCharWriter impl = writer.varChar(name);
        if (this.isSet()) {
            impl.writeVarChar(this.holder.start, this.holder.end, this.holder.buffer);
        }
    }
}

