/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class QueryWorkUnit {
    private static final ObjectMapper MAPPER = JacksonUtils.createObjectMapper();
    private BitControl.PlanFragment rootFragment;
    private final MinorFragmentDefn rootFragmentDefn;
    private final FragmentRoot rootOperator;
    private List<BitControl.PlanFragment> fragments = new ArrayList<BitControl.PlanFragment>();
    private final List<MinorFragmentDefn> minorFragmentDefns;
    private final Wrapper rootWrapper;

    public QueryWorkUnit(FragmentRoot rootOperator, MinorFragmentDefn rootFragmentDefn, List<MinorFragmentDefn> minorFragmentDefns, Wrapper rootWrapper) {
        Preconditions.checkNotNull(rootOperator);
        Preconditions.checkNotNull(rootFragmentDefn);
        Preconditions.checkNotNull(minorFragmentDefns);
        this.rootFragmentDefn = rootFragmentDefn;
        this.rootOperator = rootOperator;
        this.minorFragmentDefns = minorFragmentDefns;
        this.rootWrapper = rootWrapper;
    }

    public BitControl.PlanFragment getRootFragment() {
        return this.rootFragment;
    }

    public MinorFragmentDefn getRootFragmentDefn() {
        return this.rootFragmentDefn;
    }

    public List<BitControl.PlanFragment> getFragments() {
        return this.fragments;
    }

    public List<MinorFragmentDefn> getMinorFragmentDefns() {
        return this.minorFragmentDefns;
    }

    public FragmentRoot getRootOperator() {
        return this.rootOperator;
    }

    public void applyPlan(PhysicalPlanReader reader) throws ForemanSetupException {
        assert (this.rootFragment == null);
        this.rootFragment = this.rootFragmentDefn.applyPlan(reader);
        assert (this.fragments.isEmpty());
        for (MinorFragmentDefn defn : this.minorFragmentDefns) {
            this.fragments.add(defn.applyPlan(reader));
        }
    }

    public String stringifyFragments() {
        StringBuilder stringBuilder = new StringBuilder();
        int fragmentCount = this.fragments.size();
        int fragmentIndex = 0;
        for (BitControl.PlanFragment planFragment : this.fragments) {
            ExecProtos.FragmentHandle fragmentHandle = planFragment.getHandle();
            stringBuilder.append("PlanFragment(");
            stringBuilder.append(++fragmentIndex);
            stringBuilder.append('/');
            stringBuilder.append(fragmentCount);
            stringBuilder.append(") major_fragment_id ");
            stringBuilder.append(fragmentHandle.getMajorFragmentId());
            stringBuilder.append(" minor_fragment_id ");
            stringBuilder.append(fragmentHandle.getMinorFragmentId());
            stringBuilder.append('\n');
            CoordinationProtos.DrillbitEndpoint endpointAssignment = planFragment.getAssignment();
            stringBuilder.append("  DrillbitEndpoint address ");
            stringBuilder.append(endpointAssignment.getAddress());
            stringBuilder.append('\n');
            String jsonString = "<<malformed JSON>>";
            stringBuilder.append("  fragment_json: ");
            try {
                Object json = MAPPER.readValue(planFragment.getFragmentJson(), Object.class);
                jsonString = MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(json);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuilder.append(jsonString);
        }
        return stringBuilder.toString();
    }

    public Wrapper getRootWrapper() {
        return this.rootWrapper;
    }

    public static class MinorFragmentDefn {
        private BitControl.PlanFragment fragment;
        private final FragmentRoot root;
        private final OptionList options;

        public MinorFragmentDefn(BitControl.PlanFragment fragment, FragmentRoot root, OptionList options) {
            this.fragment = fragment;
            this.root = root;
            this.options = options;
        }

        public FragmentRoot root() {
            return this.root;
        }

        public BitControl.PlanFragment fragment() {
            return this.fragment;
        }

        public OptionList options() {
            return this.options;
        }

        public BitControl.PlanFragment applyPlan(PhysicalPlanReader reader) throws ForemanSetupException {
            try {
                String plan = reader.writeJson(this.root);
                String optionsData = reader.writeJson(this.options);
                return BitControl.PlanFragment.newBuilder(this.fragment).setFragmentJson(plan).setOptionsJson(optionsData).build();
            }
            catch (JsonProcessingException e) {
                throw new ForemanSetupException("Failure while trying to convert fragment into json.", e);
            }
        }
    }
}

