/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContextImpl;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.RequestHandler;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.UserRpcException;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlRpcConfig;
import org.apache.drill.exec.rpc.control.CustomHandlerRegistry;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.exec.work.fragment.FragmentStatusReporter;
import org.apache.drill.exec.work.fragment.NonRootFragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlMessageHandler
implements RequestHandler<ControlConnection> {
    private static final Logger logger = LoggerFactory.getLogger(ControlMessageHandler.class);
    private final WorkManager.WorkerBee bee;
    private final CustomHandlerRegistry handlerRegistry = new CustomHandlerRegistry();

    public ControlMessageHandler(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    @Override
    public void handle(ControlConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        switch (rpcType) {
            case 6: {
                ExecProtos.FragmentHandle handle = RpcBus.get(pBody, ExecProtos.FragmentHandle.PARSER);
                this.cancelFragment(handle);
                sender.send(ControlRpcConfig.OK);
                break;
            }
            case 17: {
                BitControl.CustomMessage customMessage = RpcBus.get(pBody, BitControl.CustomMessage.PARSER);
                sender.send(this.handlerRegistry.handle(customMessage, (DrillBuf)dBody));
                break;
            }
            case 7: {
                BitControl.FinishedReceiver finishedReceiver = RpcBus.get(pBody, BitControl.FinishedReceiver.PARSER);
                this.receivingFragmentFinished(finishedReceiver);
                sender.send(ControlRpcConfig.OK);
                break;
            }
            case 8: {
                BitControl.FragmentStatus status = RpcBus.get(pBody, BitControl.FragmentStatus.PARSER);
                this.requestFragmentStatus(status);
                sender.send(ControlRpcConfig.OK);
                break;
            }
            case 15: {
                UserBitShared.QueryId queryId = RpcBus.get(pBody, UserBitShared.QueryId.PARSER);
                GeneralRPCProtos.Ack cancelStatus = this.requestQueryCancel(queryId);
                if (cancelStatus.getOk()) {
                    sender.send(ControlRpcConfig.OK);
                    break;
                }
                sender.send(ControlRpcConfig.FAIL);
                break;
            }
            case 3: {
                BitControl.InitializeFragments fragments = RpcBus.get(pBody, BitControl.InitializeFragments.PARSER);
                this.initializeFragment(fragments);
                sender.send(ControlRpcConfig.OK);
                break;
            }
            case 10: {
                UserBitShared.QueryId queryId = RpcBus.get(pBody, UserBitShared.QueryId.PARSER);
                UserBitShared.QueryProfile profile = this.requestQueryStatus(queryId);
                sender.send(new Response(BitControl.RpcType.RESP_QUERY_STATUS, profile, new ByteBuf[0]));
                break;
            }
            case 16: {
                ExecProtos.FragmentHandle handle = RpcBus.get(pBody, ExecProtos.FragmentHandle.PARSER);
                this.resumeFragment(handle);
                sender.send(ControlRpcConfig.OK);
                break;
            }
            default: {
                throw new RpcException("Not yet supported.");
            }
        }
    }

    public void startNewFragment(BitControl.PlanFragment fragment, DrillbitContext drillbitContext) throws UserRpcException {
        logger.debug("Received remote fragment start instruction: {}", (Object)fragment);
        try {
            FragmentContextImpl fragmentContext = new FragmentContextImpl(drillbitContext, fragment, drillbitContext.getFunctionImplementationRegistry());
            FragmentStatusReporter statusReporter = new FragmentStatusReporter(fragmentContext);
            FragmentExecutor fragmentExecutor = new FragmentExecutor(fragmentContext, fragment, statusReporter);
            if (fragment.getLeafFragment()) {
                this.bee.addFragmentRunner(fragmentExecutor);
            } else {
                NonRootFragmentManager manager = new NonRootFragmentManager(fragment, fragmentExecutor, statusReporter);
                drillbitContext.getWorkBus().addFragmentManager(manager);
            }
        }
        catch (ExecutionSetupException ex) {
            throw new UserRpcException(drillbitContext.getEndpoint(), "Failed to create fragment context", ex);
        }
        catch (Exception e) {
            throw new UserRpcException(drillbitContext.getEndpoint(), "Failure while trying to start remote fragment", e);
        }
        catch (OutOfMemoryError t) {
            if (t.getMessage().startsWith("Direct buffer")) {
                throw new UserRpcException(drillbitContext.getEndpoint(), "Out of direct memory while trying to start remote fragment", t);
            }
            throw t;
        }
    }

    public GeneralRPCProtos.Ack cancelFragment(ExecProtos.FragmentHandle handle) {
        boolean removed = this.bee.getContext().getWorkBus().removeFragmentManager(handle, true);
        if (removed) {
            return Acks.OK;
        }
        FragmentExecutor runner = this.bee.getFragmentRunner(handle);
        if (runner != null) {
            runner.cancel();
            return Acks.OK;
        }
        logger.warn("Dropping request to cancel fragment. {} does not exist.", (Object)QueryIdHelper.getQueryIdentifier(handle));
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack resumeFragment(ExecProtos.FragmentHandle handle) {
        FragmentManager manager = this.bee.getContext().getWorkBus().getFragmentManager(handle);
        if (manager != null) {
            manager.unpause();
            return Acks.OK;
        }
        FragmentExecutor runner = this.bee.getFragmentRunner(handle);
        if (runner != null) {
            runner.unpause();
            return Acks.OK;
        }
        logger.warn("Dropping request to resume fragment. {} does not exist.", (Object)QueryIdHelper.getQueryIdentifier(handle));
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack receivingFragmentFinished(BitControl.FinishedReceiver finishedReceiver) {
        FragmentManager manager = this.bee.getContext().getWorkBus().getFragmentManager(finishedReceiver.getSender());
        if (manager != null) {
            manager.receivingFragmentFinished(finishedReceiver.getReceiver());
        } else {
            FragmentExecutor executor = this.bee.getFragmentRunner(finishedReceiver.getSender());
            if (executor != null) {
                executor.receivingFragmentFinished(finishedReceiver.getReceiver());
            } else {
                logger.warn("Dropping request for early fragment termination for path {} -> {} as path to executor unavailable.", (Object)QueryIdHelper.getQueryIdentifier(finishedReceiver.getSender()), (Object)QueryIdHelper.getQueryIdentifier(finishedReceiver.getReceiver()));
            }
        }
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack requestFragmentStatus(BitControl.FragmentStatus status) {
        this.bee.getContext().getWorkBus().statusUpdate(status);
        return Acks.OK;
    }

    public GeneralRPCProtos.Ack requestQueryCancel(UserBitShared.QueryId queryId) {
        return this.bee.cancelForeman(queryId, null) ? Acks.OK : Acks.FAIL;
    }

    public GeneralRPCProtos.Ack initializeFragment(BitControl.InitializeFragments fragments) throws RpcException {
        DrillbitContext drillbitContext = this.bee.getContext();
        for (int i = 0; i < fragments.getFragmentCount(); ++i) {
            this.startNewFragment(fragments.getFragment(i), drillbitContext);
        }
        return Acks.OK;
    }

    public UserBitShared.QueryProfile requestQueryStatus(UserBitShared.QueryId queryId) throws RpcException {
        Foreman foreman = this.bee.getForemanForQueryId(queryId);
        if (foreman == null) {
            throw new RpcException("Query not running on node.");
        }
        return foreman.getQueryManager().getQueryProfile();
    }

    public CustomHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }
}

