/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.filter;

import io.netty.buffer.DrillBuf;
import java.util.Arrays;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class BloomFilter {
    private static final int BYTES_PER_BUCKET = 32;
    private static final int MINIMUM_BLOOM_SIZE_IN_BYTES = 256;
    private DrillBuf byteBuf;
    private int numBytes;
    private int[] bucketMask = new int[8];

    public BloomFilter(int numBytes, BufferAllocator bufferAllocator) {
        int size = BloomFilter.adjustByteSize(numBytes);
        this.byteBuf = bufferAllocator.buffer(size);
        this.numBytes = this.byteBuf.capacity();
        this.byteBuf.writeZero(this.numBytes);
        this.byteBuf.writerIndex(this.numBytes);
    }

    public BloomFilter(int ndv, double fpp, BufferAllocator bufferAllocator) {
        this(BloomFilter.optimalNumOfBytes(ndv, fpp), bufferAllocator);
    }

    public BloomFilter(DrillBuf byteBuf) {
        this.byteBuf = byteBuf;
        this.numBytes = byteBuf.capacity();
        this.byteBuf.writerIndex(this.numBytes);
    }

    public static int adjustByteSize(int numBytes) {
        if (numBytes < 256) {
            numBytes = 256;
        }
        numBytes = numBytes + 31 & 0xFFFFFFE0;
        return numBytes;
    }

    private void setMask(int key) {
        int i;
        int[] SALT = new int[]{1203114875, 1150766481, -2010862245, -1565054819, 1884591559, 770785867, -1627633337, 1550580529};
        Arrays.fill(this.bucketMask, 0);
        for (i = 0; i < 8; ++i) {
            this.bucketMask[i] = key * SALT[i];
        }
        for (i = 0; i < 8; ++i) {
            this.bucketMask[i] = this.bucketMask[i] >>> 27;
        }
        for (i = 0; i < 8; ++i) {
            this.bucketMask[i] = 1 << this.bucketMask[i];
        }
    }

    public void insert(long hash) {
        int bucketIndex = (int)(hash >> 32) & this.numBytes / 32 - 1;
        int key = (int)hash;
        this.setMask(key);
        int initialStartIndex = bucketIndex * 32;
        for (int i = 0; i < 8; ++i) {
            int index = initialStartIndex + i * 4;
            int a = this.byteBuf.getInt(index);
            this.byteBuf.setInt(index, a |= this.bucketMask[i]);
        }
    }

    public boolean find(long hash) {
        int bucketIndex = (int)(hash >> 32) & this.numBytes / 32 - 1;
        int key = (int)hash;
        this.setMask(key);
        int startIndex = bucketIndex * 32;
        for (int i = 0; i < 8; ++i) {
            int index = startIndex + i * 4;
            int a = this.byteBuf.getInt(index);
            int b = a & this.bucketMask[i];
            if (b != 0) continue;
            return false;
        }
        return true;
    }

    public void or(BloomFilter other) {
        int thisLength;
        int otherLength = other.byteBuf.capacity();
        Preconditions.checkArgument(otherLength == (thisLength = this.byteBuf.capacity()));
        Preconditions.checkState(otherLength % 32 == 0);
        Preconditions.checkState(thisLength % 32 == 0);
        for (int i = 0; i < thisLength / 8; ++i) {
            int index = i * 8;
            long a = this.byteBuf.getLong(index);
            long b = other.byteBuf.getLong(index);
            long c = a | b;
            this.byteBuf.setLong(index, c);
        }
    }

    public static int optimalNumOfBytes(long ndv, double fpp) {
        int bits = (int)((double)(-ndv) * Math.log(fpp) / (Math.log(2.0) * Math.log(2.0)));
        --bits;
        bits |= bits >> 1;
        bits |= bits >> 2;
        bits |= bits >> 4;
        bits |= bits >> 8;
        bits |= bits >> 16;
        int bytes = ++bits / 8;
        return bytes;
    }

    public DrillBuf getContent() {
        return this.byteBuf;
    }
}

