/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.filter;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.ops.AccountingDataTunnel;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.work.filter.BloomFilter;
import org.apache.drill.exec.work.filter.RuntimeFilterDef;
import org.apache.drill.exec.work.filter.RuntimeFilterWritable;

public class RuntimeFilterReporter {
    private ExecutorFragmentContext context;

    public RuntimeFilterReporter(ExecutorFragmentContext context) {
        this.context = context;
    }

    public void sendOut(List<BloomFilter> bloomFilters, List<String> probeFields, RuntimeFilterDef runtimeFilterDef, int hashJoinOpId) {
        boolean sendToForeman = runtimeFilterDef.isSendToForeman();
        long rfIdentifier = runtimeFilterDef.getRuntimeFilterIdentifier();
        ExecProtos.FragmentHandle fragmentHandle = this.context.getHandle();
        DrillBuf[] data = new DrillBuf[bloomFilters.size()];
        ArrayList<Integer> bloomFilterSizeInBytes = new ArrayList<Integer>();
        int i = 0;
        for (BloomFilter bloomFilter : bloomFilters) {
            DrillBuf bfContent;
            data[i] = bfContent = bloomFilter.getContent();
            bloomFilterSizeInBytes.add(bfContent.capacity());
            ++i;
        }
        UserBitShared.QueryId queryId = fragmentHandle.getQueryId();
        int majorFragmentId = fragmentHandle.getMajorFragmentId();
        int minorFragmentId = fragmentHandle.getMinorFragmentId();
        BitData.RuntimeFilterBDef.Builder builder = BitData.RuntimeFilterBDef.newBuilder();
        for (String probeFiled : probeFields) {
            builder.addProbeFields(probeFiled);
        }
        BitData.RuntimeFilterBDef runtimeFilterB = builder.setQueryId(queryId).setMajorFragmentId(majorFragmentId).setMinorFragmentId(minorFragmentId).setToForeman(sendToForeman).setHjOpId(hashJoinOpId).setRfIdentifier(rfIdentifier).addAllBloomFilterSizeInBytes(bloomFilterSizeInBytes).build();
        RuntimeFilterWritable runtimeFilterWritable = new RuntimeFilterWritable(runtimeFilterB, data);
        if (sendToForeman) {
            CoordinationProtos.DrillbitEndpoint foremanEndpoint = this.context.getForemanEndpoint();
            AccountingDataTunnel dataTunnel = this.context.getDataTunnel(foremanEndpoint);
            dataTunnel.sendRuntimeFilter(runtimeFilterWritable);
        } else {
            this.context.addRuntimeFilter(runtimeFilterWritable);
        }
    }
}

