/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.filter;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.work.filter.BloomFilter;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public class RuntimeFilterWritable
implements AutoCloseables.Closeable {
    private BitData.RuntimeFilterBDef runtimeFilterBDef;
    private DrillBuf[] data;
    private String identifier;

    public RuntimeFilterWritable(BitData.RuntimeFilterBDef runtimeFilterBDef, DrillBuf ... data) {
        List<Integer> bfSizeInBytes = runtimeFilterBDef.getBloomFilterSizeInBytesList();
        int bufArrLen = data.length;
        Preconditions.checkArgument(bfSizeInBytes.size() == bufArrLen, "the input DrillBuf number does not match the metadata definition!");
        this.runtimeFilterBDef = runtimeFilterBDef;
        this.data = data;
        this.identifier = "majorFragmentId:" + runtimeFilterBDef.getMajorFragmentId() + ",minorFragmentId:" + runtimeFilterBDef.getMinorFragmentId() + ", srcOperatorId:" + runtimeFilterBDef.getHjOpId();
    }

    public BitData.RuntimeFilterBDef getRuntimeFilterBDef() {
        return this.runtimeFilterBDef;
    }

    public DrillBuf[] getData() {
        return this.data;
    }

    public void setData(DrillBuf ... data) {
        this.data = data;
    }

    public List<BloomFilter> unwrap() {
        List<Integer> sizeInBytes = this.runtimeFilterBDef.getBloomFilterSizeInBytesList();
        ArrayList<BloomFilter> bloomFilters = new ArrayList<BloomFilter>(sizeInBytes.size());
        for (int i = 0; i < sizeInBytes.size(); ++i) {
            DrillBuf byteBuf = this.data[i];
            int offset = 0;
            int size = sizeInBytes.get(i);
            DrillBuf bloomFilterContent = byteBuf.slice(offset, size);
            BloomFilter bloomFilter = new BloomFilter(bloomFilterContent);
            bloomFilters.add(bloomFilter);
        }
        return bloomFilters;
    }

    public void aggregate(RuntimeFilterWritable runtimeFilterWritable) {
        List<BloomFilter> thisFilters = this.unwrap();
        List<BloomFilter> otherFilters = runtimeFilterWritable.unwrap();
        for (int i = 0; i < thisFilters.size(); ++i) {
            BloomFilter thisOne = thisFilters.get(i);
            BloomFilter otherOne = otherFilters.get(i);
            thisOne.or(otherOne);
        }
        for (BloomFilter bloomFilter : otherFilters) {
            bloomFilter.getContent().clear();
        }
    }

    public RuntimeFilterWritable duplicate(BufferAllocator bufferAllocator) {
        int len = this.data.length;
        DrillBuf[] cloned = new DrillBuf[len];
        int i = 0;
        for (DrillBuf src : this.data) {
            int capacity = src.readableBytes();
            DrillBuf duplicateOne = bufferAllocator.buffer(capacity);
            int readerIndex = src.readerIndex();
            duplicateOne.writeBytes(src);
            src.readerIndex(readerIndex);
            cloned[i] = duplicateOne;
            ++i;
        }
        return new RuntimeFilterWritable(this.runtimeFilterBDef, cloned);
    }

    public void retainBuffers(int increment) {
        if (increment <= 0) {
            return;
        }
        for (DrillBuf buf : this.data) {
            buf.retain(increment);
        }
    }

    public RuntimeFilterWritable newRuntimeFilterWritable(BufferAllocator bufferAllocator) {
        int bufNum = this.data.length;
        DrillBuf[] newBufs = new DrillBuf[bufNum];
        int i = 0;
        for (DrillBuf buf : this.data) {
            DrillBuf transferredBuffer;
            newBufs[i] = transferredBuffer = buf.transferOwnership((BufferAllocator)bufferAllocator).buffer;
            ++i;
        }
        return new RuntimeFilterWritable(this.runtimeFilterBDef, newBufs);
    }

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof RuntimeFilterWritable) {
            RuntimeFilterWritable otherRFW = (RuntimeFilterWritable)other;
            return this.identifier.equals(otherRFW.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public void close() {
        for (DrillBuf buf : this.data) {
            buf.release();
        }
    }
}

