/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.common.util.JacksonUtils;
import org.apache.drill.exec.exception.OptimizerException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.opt.BasicOptimizer;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.DrillSqlWorker;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.UserClientConnection;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.FailureUtils;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.testing.ControlsInjector;
import org.apache.drill.exec.testing.ControlsInjectorFactory;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.filter.RuntimeFilterRouter;
import org.apache.drill.exec.work.foreman.ForemanException;
import org.apache.drill.exec.work.foreman.ForemanSetupException;
import org.apache.drill.exec.work.foreman.FragmentsRunner;
import org.apache.drill.exec.work.foreman.LoggedQuery;
import org.apache.drill.exec.work.foreman.QueryManager;
import org.apache.drill.exec.work.foreman.QueryStateProcessor;
import org.apache.drill.exec.work.foreman.rm.QueryQueue;
import org.apache.drill.exec.work.foreman.rm.QueryResourceManager;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Foreman
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Foreman.class);
    private static final Logger queryLogger = LoggerFactory.getLogger((String)"query.logger");
    private static final ControlsInjector injector = ControlsInjectorFactory.getInjector(Foreman.class);
    private static final ObjectMapper MAPPER = JacksonUtils.createObjectMapper();
    private final UserBitShared.QueryId queryId;
    private final String queryIdString;
    private final UserProtos.RunQuery queryRequest;
    private final QueryContext queryContext;
    private final QueryManager queryManager;
    private final DrillbitContext drillbitContext;
    private final UserClientConnection initiatingClient;
    private boolean resume;
    private final QueryResourceManager queryRM;
    private final ResponseSendListener responseListener = new ResponseSendListener();
    private final GenericFutureListener<Future<Void>> closeListener = future -> this.cancel();
    private final Future<Void> closeFuture;
    private final FragmentsRunner fragmentsRunner;
    private final QueryStateProcessor queryStateProcessor;
    private String queryText;
    private RuntimeFilterRouter runtimeFilterRouter;
    private final boolean enableRuntimeFilter;

    public Foreman(WorkManager.WorkerBee bee, DrillbitContext drillbitContext, UserClientConnection connection, UserBitShared.QueryId queryId, UserProtos.RunQuery queryRequest) {
        this.queryId = queryId;
        this.queryIdString = QueryIdHelper.getQueryId(queryId);
        this.queryRequest = queryRequest;
        this.drillbitContext = drillbitContext;
        this.initiatingClient = connection;
        this.closeFuture = this.initiatingClient.getClosureFuture();
        this.closeFuture.addListener(this.closeListener);
        int autoLimit = queryRequest.getAutolimitRowcount();
        if (autoLimit > 0) {
            connection.getSession().getOptions().setLocalOption("exec.query.max_rows", autoLimit);
        }
        this.queryContext = new QueryContext(connection.getSession(), drillbitContext, queryId);
        this.queryManager = new QueryManager(queryId, queryRequest, drillbitContext.getStoreProvider(), drillbitContext.getClusterCoordinator(), this);
        this.queryRM = drillbitContext.getResourceManager().newQueryRM(this);
        this.fragmentsRunner = new FragmentsRunner(bee, this.initiatingClient, drillbitContext, this);
        this.queryStateProcessor = new QueryStateProcessor(this.queryIdString, this.queryManager, drillbitContext, new ForemanResult());
        this.enableRuntimeFilter = this.queryContext.getOptions().getOption((String)"exec.hashjoin.enable.runtime_filter").bool_val;
    }

    public UserBitShared.QueryId getQueryId() {
        return this.queryId;
    }

    public UserBitShared.QueryResult.QueryState getState() {
        return this.queryStateProcessor.getState();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public void cancel() {
        logger.debug("Cancel Foreman");
        this.queryStateProcessor.cancel();
    }

    public void addToEventQueue(UserBitShared.QueryResult.QueryState state, Exception exception) {
        this.queryStateProcessor.addToEventQueue(state, exception);
    }

    public void resume() {
        this.resume = true;
        this.queryContext.getExecutionControls().unpauseAll();
        this.queryManager.unpauseExecutingFragments(this.drillbitContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread currentThread = Thread.currentThread();
        String originalName = currentThread.getName();
        currentThread.setName(this.queryIdString + ":foreman");
        try {
            if (!this.drillbitContext.isForemanOnline()) {
                throw new ForemanException("Query submission failed since Foreman is shutting down.");
            }
        }
        catch (ForemanException e) {
            logger.debug("Failure while submitting query", (Throwable)e);
            this.queryStateProcessor.addToEventQueue(UserBitShared.QueryResult.QueryState.FAILED, e);
        }
        this.queryText = this.queryRequest.getPlan();
        try {
            this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.PLANNING, null);
            injector.injectChecked(this.queryContext.getExecutionControls(), "run-try-beginning", ForemanException.class);
            switch (this.queryRequest.getType()) {
                case LOGICAL: {
                    this.parseAndRunLogicalPlan(this.queryRequest.getPlan());
                    break;
                }
                case PHYSICAL: {
                    this.parseAndRunPhysicalPlan(this.queryRequest.getPlan());
                    break;
                }
                case SQL: {
                    String sql = this.queryRequest.getPlan();
                    logger.info("Query text for query with id {} issued by {}: {}", new Object[]{this.queryIdString, this.queryContext.getQueryUserName(), sql});
                    this.runSQL(sql);
                    break;
                }
                case EXECUTION: {
                    this.runFragment(this.queryRequest.getFragmentsList());
                    break;
                }
                case PREPARED_STATEMENT: {
                    this.runPreparedStatement(this.queryRequest.getPreparedStatementHandle());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            injector.injectChecked(this.queryContext.getExecutionControls(), "run-try-end", ForemanException.class);
        }
        catch (UserException | ForemanException e) {
            this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.FAILED, e);
        }
        catch (OutOfMemoryError | OutOfMemoryException e) {
            if (FailureUtils.isDirectMemoryOOM(e)) {
                this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.FAILED, UserException.memoryError(e).build(logger));
            } else {
                FailureUtils.unrecoverableFailure(e, "Unable to handle out of memory condition in Foreman.", -1);
            }
        }
        catch (Throwable ex) {
            this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.FAILED, new ForemanException("Unexpected exception during fragment initialization: " + ex.getMessage(), ex));
        }
        finally {
            currentThread.setName(originalName);
        }
    }

    public void startProcessingEvents() {
        this.queryStateProcessor.startProcessingEvents();
        if (this.resume) {
            this.resume();
        }
    }

    private ProfileOption getProfileOption(QueryContext queryContext) {
        if (queryContext.isSkipProfileWrite()) {
            return ProfileOption.NONE;
        }
        QueryOptionManager options = queryContext.getOptions();
        if (!options.getBoolean("exec.query_profile.save")) {
            return ProfileOption.NONE;
        }
        if (options.getBoolean("exec.query_profile.debug_mode")) {
            return ProfileOption.SYNC;
        }
        return ProfileOption.ASYNC;
    }

    private void parseAndRunLogicalPlan(String json) throws ExecutionSetupException {
        LogicalPlan logicalPlan;
        try {
            logicalPlan = this.drillbitContext.getPlanReader().readLogicalPlan(json);
        }
        catch (IOException e) {
            throw new ForemanException("Failure parsing logical plan.", e);
        }
        if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.LOGICAL) {
            throw new ForemanException("Failure running plan.  You requested a result mode of LOGICAL and submitted a logical plan.  In this case you're output mode must be PHYSICAL or EXEC.");
        }
        this.log(logicalPlan);
        PhysicalPlan physicalPlan = this.convert(logicalPlan);
        if (logicalPlan.getProperties().resultMode == PlanProperties.Generator.ResultMode.PHYSICAL) {
            this.returnPhysical(physicalPlan);
            return;
        }
        this.log(physicalPlan);
        this.runPhysicalPlan(physicalPlan);
    }

    private void log(LogicalPlan plan) {
        if (logger.isDebugEnabled()) {
            logger.debug("Logical {}", (Object)plan.unparse(this.queryContext.getLpPersistence()));
        }
    }

    private void log(PhysicalPlan plan) {
        if (logger.isDebugEnabled()) {
            try {
                String planText = this.queryContext.getLpPersistence().getMapper().writeValueAsString((Object)plan);
                logger.debug("Physical {}", (Object)planText);
            }
            catch (IOException e) {
                logger.warn("Error while attempting to log physical plan.", (Throwable)e);
            }
        }
    }

    private void returnPhysical(PhysicalPlan plan) throws ExecutionSetupException {
        String jsonPlan = plan.unparse(this.queryContext.getLpPersistence().getMapper().writer());
        this.runPhysicalPlan(DirectPlan.createDirectPlan(this.queryContext, new PhysicalFromLogicalExplain(jsonPlan)));
    }

    private void parseAndRunPhysicalPlan(String json) throws ExecutionSetupException {
        try {
            PhysicalPlan plan = this.drillbitContext.getPlanReader().readPhysicalPlan(json);
            this.runPhysicalPlan(plan);
        }
        catch (IOException e) {
            throw new ForemanSetupException("Failure while parsing physical plan.", e);
        }
    }

    private void runPhysicalPlan(PhysicalPlan plan) throws ExecutionSetupException {
        this.runPhysicalPlan(plan, null);
    }

    private void runPhysicalPlan(PhysicalPlan plan, Pointer<String> textPlan) throws ExecutionSetupException {
        Foreman.validatePlan(plan);
        this.queryRM.visitAbstractPlan(plan);
        QueryWorkUnit work = this.getQueryWorkUnit(plan, this.queryRM);
        if (this.enableRuntimeFilter) {
            this.runtimeFilterRouter = new RuntimeFilterRouter(work, this.drillbitContext);
            this.runtimeFilterRouter.collectRuntimeFilterParallelAndControlInfo();
        }
        if (textPlan != null) {
            this.queryManager.setPlanText((String)textPlan.value);
            this.queryManager.setPlanProperties(plan.getProperties());
        }
        this.queryRM.visitPhysicalPlan(work);
        this.queryRM.setCost(plan.totalCost());
        this.queryManager.setTotalCost(plan.totalCost());
        work.applyPlan(this.drillbitContext.getPlanReader());
        this.logWorkUnit(work);
        this.fragmentsRunner.setFragmentsInfo(work.getFragments(), work.getRootFragment(), work.getRootOperator());
        this.startQueryProcessing();
    }

    private void runFragment(List<BitControl.PlanFragment> fragmentsList) throws ExecutionSetupException {
        FragmentRoot rootOperator;
        BitControl.PlanFragment rootFragment = null;
        boolean isFirst = true;
        ArrayList<BitControl.PlanFragment> planFragments = Lists.newArrayList();
        for (BitControl.PlanFragment myFragment : fragmentsList) {
            ExecProtos.FragmentHandle handle = myFragment.getHandle();
            ExecProtos.FragmentHandle newFragmentHandle = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(handle.getMajorFragmentId()).setMinorFragmentId(handle.getMinorFragmentId()).setQueryId(this.queryId).build();
            BitControl.PlanFragment newFragment = BitControl.PlanFragment.newBuilder(myFragment).setHandle(newFragmentHandle).build();
            if (isFirst) {
                rootFragment = newFragment;
                isFirst = false;
                continue;
            }
            planFragments.add(newFragment);
        }
        assert (rootFragment != null);
        try {
            rootOperator = this.drillbitContext.getPlanReader().readFragmentRoot(rootFragment.getFragmentJson());
        }
        catch (IOException e) {
            throw new ExecutionSetupException(String.format("Unable to parse FragmentRoot from fragment: %s", rootFragment.getFragmentJson()));
        }
        this.queryRM.setCost(rootOperator.getCost().getOutputRowCount());
        this.fragmentsRunner.setFragmentsInfo(planFragments, rootFragment, rootOperator);
        this.startQueryProcessing();
    }

    private void startQueryProcessing() {
        this.enqueue();
        this.runFragments();
        this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.RUNNING, null);
    }

    private void enqueue() {
        this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.ENQUEUED, null);
        try {
            this.queryRM.admit();
            this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.STARTING, null);
            String queueName = this.queryRM.queueName();
            this.queryManager.setQueueName(queueName == null ? "Unknown" : queueName);
        }
        catch (QueryQueue.QueryQueueException | QueryQueue.QueueTimeoutException e) {
            try {
                this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.FAILED, e);
                String queueName = this.queryRM.queueName();
                this.queryManager.setQueueName(queueName == null ? "Unknown" : queueName);
            }
            catch (Throwable throwable) {
                String queueName = this.queryRM.queueName();
                this.queryManager.setQueueName(queueName == null ? "Unknown" : queueName);
                throw throwable;
            }
        }
    }

    private void runFragments() {
        try {
            this.fragmentsRunner.submit();
        }
        catch (Exception e) {
            this.queryStateProcessor.moveToState(UserBitShared.QueryResult.QueryState.FAILED, e);
        }
        finally {
            this.startProcessingEvents();
        }
    }

    private void runPreparedStatement(UserProtos.PreparedStatementHandle preparedStatementHandle) throws ExecutionSetupException {
        ExecProtos.ServerPreparedStatementState serverState;
        try {
            serverState = ExecProtos.ServerPreparedStatementState.PARSER.parseFrom(preparedStatementHandle.getServerInfo());
        }
        catch (InvalidProtocolBufferException ex) {
            throw UserException.parseError(ex).message("Failed to parse the prepared statement handle. Make sure the handle is same as one returned from create prepared statement call.", new Object[0]).build(logger);
        }
        this.queryText = serverState.getSqlQuery();
        logger.info("Prepared statement query for QueryId {} : {}", (Object)this.queryId, (Object)this.queryText);
        this.runSQL(this.queryText);
    }

    private static void validatePlan(PhysicalPlan plan) throws ForemanSetupException {
        if (plan.getProperties().resultMode != PlanProperties.Generator.ResultMode.EXEC) {
            throw new ForemanSetupException(String.format("Failure running plan.  You requested a result mode of %s and a physical plan can only be output as EXEC", new Object[]{plan.getProperties().resultMode}));
        }
    }

    private QueryWorkUnit getQueryWorkUnit(PhysicalPlan plan, QueryResourceManager rm) throws ExecutionSetupException {
        PhysicalOperator rootOperator = plan.getSortedOperators(false).iterator().next();
        Fragment rootFragment = rootOperator.accept(MakeFragmentsVisitor.INSTANCE, null);
        return rm.getParallelizer(plan.getProperties().hasResourcePlan).generateWorkUnit(this.queryContext.getOptions().getOptionList(), this.queryContext.getCurrentEndpoint(), this.queryId, this.queryContext.getOnlineEndpoints(), rootFragment, this.initiatingClient.getSession(), this.queryContext.getQueryContextInfo());
    }

    private void logWorkUnit(QueryWorkUnit queryWorkUnit) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace(String.format("PlanFragments for query %s \n%s", this.queryId, queryWorkUnit.stringifyFragments()));
    }

    private void runSQL(String sql) throws ExecutionSetupException {
        Pointer<String> textPlan = new Pointer<String>();
        PhysicalPlan plan = DrillSqlWorker.getPlan(this.queryContext, sql, textPlan);
        this.runPhysicalPlan(plan, textPlan);
    }

    private PhysicalPlan convert(LogicalPlan plan) throws OptimizerException {
        if (logger.isDebugEnabled()) {
            logger.debug("Converting logical plan {}.", (Object)plan.toJsonStringSafe(this.queryContext.getLpPersistence()));
        }
        return new BasicOptimizer(this.queryContext, this.initiatingClient).optimize(new BasicOptimizer.BasicOptimizationContext(this.queryContext), plan);
    }

    public RuntimeFilterRouter getRuntimeFilterRouter() {
        return this.runtimeFilterRouter;
    }

    private static class ResponseSendListener
    extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
        private ResponseSendListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.info("Failure while trying communicate query result to initiating client. This would happen if a client is disconnected before response notice can be sent.", (Throwable)ex);
        }

        @Override
        public void interrupted(InterruptedException e) {
            logger.warn("Interrupted while waiting for RPC outcome of sending final query result to initiating client.");
        }
    }

    public static enum ProfileOption {
        SYNC,
        ASYNC,
        NONE;

    }

    public class ForemanResult
    implements AutoCloseable {
        private UserBitShared.QueryResult.QueryState resultState = null;
        private volatile Exception resultException = null;
        private boolean isClosed = false;

        public void setCompleted(UserBitShared.QueryResult.QueryState queryState) {
            Preconditions.checkArgument(queryState == UserBitShared.QueryResult.QueryState.COMPLETED || queryState == UserBitShared.QueryResult.QueryState.CANCELED);
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState == null);
            this.resultState = queryState;
        }

        public void setFailed(Exception exception) {
            Preconditions.checkArgument(exception != null);
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState == null);
            this.resultState = UserBitShared.QueryResult.QueryState.FAILED;
            this.resultException = exception;
        }

        public void setForceFailure(Exception exception) {
            Preconditions.checkArgument(exception != null);
            Preconditions.checkState(!this.isClosed);
            this.resultState = UserBitShared.QueryResult.QueryState.FAILED;
            this.resultException = exception;
        }

        private void addException(Exception exception) {
            assert (exception != null);
            if (this.resultException == null) {
                this.resultException = exception;
            } else {
                this.resultException.addSuppressed(exception);
            }
        }

        public Exception getException() {
            return this.resultException;
        }

        private void suppressingClose(AutoCloseable autoCloseable) {
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState != null);
            if (autoCloseable == null) {
                return;
            }
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                this.resultState = UserBitShared.QueryResult.QueryState.FAILED;
                this.addException(e);
            }
        }

        private void logQuerySummary() {
            try {
                LoggedQuery q = new LoggedQuery(Foreman.this.queryIdString, Foreman.this.queryContext.getQueryContextInfo().getDefaultSchemaName(), Foreman.this.queryText, new Date(Foreman.this.queryContext.getQueryContextInfo().getQueryStartTime()), new Date(System.currentTimeMillis()), Foreman.this.queryStateProcessor.getState(), Foreman.this.queryContext.getQueryUserCredentials().getUserName(), Foreman.this.initiatingClient.getRemoteAddress());
                queryLogger.info(MAPPER.writeValueAsString((Object)q));
            }
            catch (Exception e) {
                logger.error("Failure while recording query information to query log.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            UserException uex;
            Preconditions.checkState(!this.isClosed);
            Preconditions.checkState(this.resultState != null);
            logger.debug(Foreman.this.queryIdString + ": cleaning up.");
            injector.injectPause(Foreman.this.queryContext.getExecutionControls(), "foreman-cleanup", logger);
            if (Foreman.this.enableRuntimeFilter && Foreman.this.runtimeFilterRouter != null) {
                Foreman.this.runtimeFilterRouter.waitForComplete();
            }
            Foreman.this.closeFuture.removeListener(Foreman.this.closeListener);
            this.logQuerySummary();
            Foreman.this.drillbitContext.getWorkBus().removeFragmentStatusListener(Foreman.this.queryId);
            Foreman.this.drillbitContext.getClusterCoordinator().removeDrillbitStatusListener(Foreman.this.queryManager.getDrillbitStatusListener());
            this.suppressingClose(Foreman.this.queryContext);
            if (this.resultState != Foreman.this.queryStateProcessor.getState()) {
                this.suppressingClose(() -> Foreman.this.queryStateProcessor.recordNewState(this.resultState));
            }
            Foreman.this.queryStateProcessor.close();
            UserBitShared.QueryResult.Builder resultBuilder = UserBitShared.QueryResult.newBuilder().setQueryId(Foreman.this.queryId).setQueryState(this.resultState);
            if (this.resultException != null) {
                boolean verbose = ((Foreman)Foreman.this).queryContext.getOptions().getOption((String)"exec.errors.verbose").bool_val;
                uex = this.resultException instanceof UserException ? (UserException)this.resultException : UserException.systemError(this.resultException).addIdentity(Foreman.this.queryContext.getCurrentEndpoint()).build(logger);
                resultBuilder.addError(uex.getOrCreatePBError(verbose));
            } else {
                uex = null;
            }
            ProfileOption profileOption = Foreman.this.getProfileOption(Foreman.this.queryContext);
            if (profileOption == ProfileOption.SYNC) {
                Foreman.this.queryManager.writeFinalProfile(uex);
            }
            try {
                Foreman.this.initiatingClient.sendResult(Foreman.this.responseListener, resultBuilder.build());
            }
            catch (Exception e) {
                this.addException(e);
                logger.warn("Exception sending result to client", (Throwable)this.resultException);
            }
            if (profileOption == ProfileOption.ASYNC) {
                Foreman.this.queryManager.writeFinalProfile(uex);
            }
            Foreman.this.fragmentsRunner.getBee().retireForeman(Foreman.this);
            try {
                Foreman.this.queryContext.close();
            }
            catch (Exception e) {
                logger.error("Unable to close query context for query {}", (Object)QueryIdHelper.getQueryId(Foreman.this.queryId), (Object)e);
            }
            try {
                Foreman.this.queryManager.close();
            }
            catch (Exception e) {
                logger.warn("unable to close query manager", (Throwable)e);
            }
            try {
                Foreman.this.queryRM.exit();
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    public static class PhysicalFromLogicalExplain {
        public final String json;

        public PhysicalFromLogicalExplain(String json) {
            this.json = json;
        }
    }
}

