/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;

public class FragmentData {
    private final boolean isLocal;
    private volatile BitControl.FragmentStatus status;
    private volatile long lastStatusUpdate = System.currentTimeMillis();
    private volatile long lastProgress = System.currentTimeMillis();
    private final CoordinationProtos.DrillbitEndpoint endpoint;

    public FragmentData(ExecProtos.FragmentHandle handle, CoordinationProtos.DrillbitEndpoint endpoint, boolean isLocal) {
        this.endpoint = endpoint;
        this.isLocal = isLocal;
        UserBitShared.MinorFragmentProfile f = UserBitShared.MinorFragmentProfile.newBuilder().setState(UserBitShared.FragmentState.SENDING).setMinorFragmentId(handle.getMinorFragmentId()).setEndpoint(endpoint).build();
        this.status = BitControl.FragmentStatus.newBuilder().setHandle(handle).setProfile(f).build();
    }

    public void setStatus(BitControl.FragmentStatus newStatus) {
        long time;
        this.lastStatusUpdate = time = System.currentTimeMillis();
        if (this.madeProgress(this.status, newStatus)) {
            this.lastProgress = time;
        }
        this.status = newStatus;
    }

    public UserBitShared.FragmentState getState() {
        return this.status.getProfile().getState();
    }

    public UserBitShared.MinorFragmentProfile getProfile() {
        return this.status.getProfile().toBuilder().setLastUpdate(this.lastStatusUpdate).setLastProgress(this.lastProgress).build();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ExecProtos.FragmentHandle getHandle() {
        return this.status.getHandle();
    }

    private boolean madeProgress(BitControl.FragmentStatus prev, BitControl.FragmentStatus cur) {
        UserBitShared.MinorFragmentProfile previous = prev.getProfile();
        UserBitShared.MinorFragmentProfile current = cur.getProfile();
        if (previous.getState() != current.getState()) {
            return true;
        }
        if (previous.getOperatorProfileCount() != current.getOperatorProfileCount()) {
            return true;
        }
        for (int i = 0; i < current.getOperatorProfileCount(); ++i) {
            if (!this.madeProgress(previous.getOperatorProfile(i), current.getOperatorProfile(i))) continue;
            return true;
        }
        return false;
    }

    private boolean madeProgress(UserBitShared.OperatorProfile prev, UserBitShared.OperatorProfile cur) {
        return prev.getInputProfileCount() != cur.getInputProfileCount() || !prev.getInputProfileList().equals(cur.getInputProfileList()) || prev.getMetricCount() != cur.getMetricCount() || !prev.getMetricList().equals(cur.getMetricList());
    }

    public String toString() {
        return "FragmentData [isLocal=" + this.isLocal + ", status=" + this.status + ", lastStatusUpdate=" + this.lastStatusUpdate + ", endpoint=" + this.endpoint + "]";
    }
}

