/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.rm.DefaultResourceManager;
import org.apache.drill.exec.work.foreman.rm.DistributedQueryQueue;
import org.apache.drill.exec.work.foreman.rm.QueryResourceAllocator;
import org.apache.drill.exec.work.foreman.rm.QueryResourceManager;
import org.apache.drill.exec.work.foreman.rm.ResourceManager;
import org.apache.drill.exec.work.foreman.rm.ThrottledResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicResourceManager
implements ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(DynamicResourceManager.class);
    private final DrillbitContext context;
    private ResourceManager defaultRm;
    private ResourceManager queueingRm;
    private ResourceManager activeRm;
    public long nextUpdateTime;
    public final int recheckDelayMs = 5000;

    public DynamicResourceManager(DrillbitContext context) {
        this.context = context;
        this.refreshRM();
    }

    public synchronized ResourceManager activeRM() {
        this.refreshRM();
        return this.activeRm;
    }

    @Override
    public long memoryPerNode() {
        return this.activeRm.memoryPerNode();
    }

    @Override
    public int cpusPerNode() {
        return this.activeRm.cpusPerNode();
    }

    @Override
    public synchronized QueryResourceAllocator newResourceAllocator(QueryContext queryContext) {
        this.refreshRM();
        return this.activeRm.newResourceAllocator(queryContext);
    }

    @Override
    public synchronized QueryResourceManager newQueryRM(Foreman foreman) {
        this.refreshRM();
        return this.activeRm.newQueryRM(foreman);
    }

    private void refreshRM() {
        long now = System.currentTimeMillis();
        if (now < this.nextUpdateTime) {
            return;
        }
        this.nextUpdateTime = now + 5000L;
        SystemOptionManager systemOptions = this.context.getOptionManager();
        if (systemOptions.getOption(ExecConstants.ENABLE_QUEUE)) {
            if (this.queueingRm == null) {
                DistributedQueryQueue.StatusAdapter statusAdapter = new DistributedQueryQueue.StatusAdapter(){

                    @Override
                    public boolean inShutDown() {
                        return false;
                    }
                };
                this.queueingRm = new ThrottledResourceManager(this.context, new DistributedQueryQueue(this.context, statusAdapter));
            }
            if (this.activeRm != this.queueingRm) {
                logger.debug("Enabling ZK-based query queue.");
                this.activeRm = this.queueingRm;
            }
        } else {
            if (this.defaultRm == null) {
                this.defaultRm = new DefaultResourceManager();
            }
            if (this.activeRm != this.defaultRm) {
                logger.debug("Disabling ZK-based query queue.");
                this.activeRm = this.defaultRm;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RuntimeException ex = null;
        try {
            if (this.defaultRm != null) {
                this.defaultRm.close();
            }
        }
        catch (RuntimeException e) {
            ex = e;
        }
        finally {
            this.defaultRm = null;
        }
        try {
            if (this.queueingRm != null) {
                this.queueingRm.close();
            }
        }
        catch (RuntimeException e) {
            ex = ex == null ? e : ex;
        }
        finally {
            this.queueingRm = null;
        }
        this.activeRm = null;
        if (ex == null) {
            return;
        }
        if (ex instanceof UserException) {
            throw (UserException)ex;
        }
        throw UserException.systemError(ex).addContext("Failure closing resource managers.").build(logger);
    }
}

