/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.local.LocalClusterCoordinator;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.foreman.rm.DefaultResourceManager;
import org.apache.drill.exec.work.foreman.rm.DynamicResourceManager;
import org.apache.drill.exec.work.foreman.rm.EmbeddedQueryQueue;
import org.apache.drill.exec.work.foreman.rm.ResourceManager;
import org.apache.drill.exec.work.foreman.rm.ThrottledResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ResourceManagerBuilder.class);
    private DrillbitContext context;

    public ResourceManagerBuilder(DrillbitContext context) {
        this.context = context;
    }

    public ResourceManager build() {
        ClusterCoordinator coord = this.context.getClusterCoordinator();
        DrillConfig config = this.context.getConfig();
        if (coord instanceof LocalClusterCoordinator) {
            if (config.getBoolean(EmbeddedQueryQueue.ENABLED)) {
                logger.debug("Enabling embedded, local query queue.");
                return new ThrottledResourceManager(this.context, new EmbeddedQueryQueue(this.context));
            }
            logger.debug("No query queueing enabled.");
            return new DefaultResourceManager();
        }
        return new DynamicResourceManager(this.context);
    }
}

