/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import java.io.IOException;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.rpc.data.IncomingDataBatch;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.apache.drill.exec.work.fragment.FragmentExecutor;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.exec.work.fragment.FragmentStatusReporter;

public abstract class AbstractFragmentManager
implements FragmentManager {
    protected final IncomingBuffers buffers;
    protected final FragmentExecutor fragmentExecutor;
    protected final ExecProtos.FragmentHandle fragmentHandle;
    protected final ExecutorFragmentContext fragmentContext;
    protected volatile boolean cancel = false;

    public AbstractFragmentManager(BitControl.PlanFragment fragment, FragmentExecutor executor, FragmentStatusReporter statusReporter, FragmentRoot rootOperator) {
        this.fragmentHandle = fragment.getHandle();
        this.fragmentContext = executor.getContext();
        this.buffers = new IncomingBuffers(fragment, this.fragmentContext);
        this.fragmentContext.setBuffers(this.buffers);
        this.fragmentExecutor = executor;
    }

    public AbstractFragmentManager(BitControl.PlanFragment fragment, FragmentExecutor executor, FragmentStatusReporter statusReporter) {
        this(fragment, executor, statusReporter, null);
    }

    @Override
    public boolean handle(IncomingDataBatch batch) throws FragmentSetupException, IOException {
        return this.buffers.batchArrived(batch);
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void unpause() {
        this.fragmentExecutor.unpause();
    }

    @Override
    public ExecProtos.FragmentHandle getHandle() {
        return this.fragmentHandle;
    }

    @Override
    public boolean isWaiting() {
        return !this.buffers.isDone() && !this.cancel;
    }

    @Override
    public FragmentContext getFragmentContext() {
        return this.fragmentContext;
    }

    @Override
    public FragmentExecutor getRunnable() {
        return this.fragmentExecutor;
    }

    @Override
    public abstract void receivingFragmentFinished(ExecProtos.FragmentHandle var1);

    @Override
    public void cancel() {
        this.cancel = true;
        this.fragmentExecutor.cancel();
    }
}

