/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.fragment;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.control.ControlTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentStatusReporter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(FragmentStatusReporter.class);
    protected final ExecutorFragmentContext context;
    protected final AtomicReference<CoordinationProtos.DrillbitEndpoint> foremanDrillbit;

    public FragmentStatusReporter(ExecutorFragmentContext context) {
        this.context = context;
        this.foremanDrillbit = new AtomicReference<CoordinationProtos.DrillbitEndpoint>(context.getForemanEndpoint());
    }

    BitControl.FragmentStatus getStatus(UserBitShared.FragmentState state) {
        return this.getStatus(state, null);
    }

    private BitControl.FragmentStatus getStatus(UserBitShared.FragmentState state, UserException ex) {
        BitControl.FragmentStatus.Builder status = BitControl.FragmentStatus.newBuilder();
        UserBitShared.MinorFragmentProfile.Builder b = UserBitShared.MinorFragmentProfile.newBuilder();
        this.context.getStats().addMetricsToStatus(b);
        b.setState(state);
        if (ex != null) {
            boolean verbose = this.context.getOptions().getOption((String)"exec.errors.verbose").bool_val;
            b.setError(ex.getOrCreatePBError(verbose));
        }
        status.setHandle(this.context.getHandle());
        b.setMemoryUsed(this.context.getAllocator().getAllocatedMemory());
        b.setMinorFragmentId(this.context.getHandle().getMinorFragmentId());
        status.setProfile(b);
        return status.build();
    }

    void stateChanged(UserBitShared.FragmentState newState) {
        BitControl.FragmentStatus status = this.getStatus(newState, null);
        logger.info("{}: State to report: {}", (Object)QueryIdHelper.getQueryIdentifier(this.context.getHandle()), (Object)newState);
        switch (newState) {
            case AWAITING_ALLOCATION: 
            case CANCELLATION_REQUESTED: 
            case CANCELLED: 
            case FINISHED: 
            case RUNNING: {
                this.sendStatus(status);
                break;
            }
            case SENDING: {
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Received state changed event for unexpected state of %s.", newState));
            }
        }
    }

    void sendStatus(BitControl.FragmentStatus status) {
        CoordinationProtos.DrillbitEndpoint foremanNode = this.foremanDrillbit.get();
        if (foremanNode == null) {
            logger.warn("{}: State {} is not reported as {} is closed", new Object[]{QueryIdHelper.getQueryIdentifier(this.context.getHandle()), status.getProfile().getState(), this});
            return;
        }
        ControlTunnel tunnel = this.context.getController().getTunnel(foremanNode);
        tunnel.sendFragmentStatus(status);
    }

    void fail(UserException ex) {
        BitControl.FragmentStatus status = this.getStatus(UserBitShared.FragmentState.FAILED, ex);
        this.sendStatus(status);
    }

    @Override
    public void close() {
        CoordinationProtos.DrillbitEndpoint foremanNode = this.foremanDrillbit.getAndSet(null);
        if (foremanNode != null) {
            logger.debug("Closing {}", (Object)this);
        } else {
            logger.warn("{} was already closed", (Object)this);
        }
    }
}

