/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.metadata;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ErrorHelper;
import org.apache.drill.exec.ops.ViewExpansionContext;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.SchemaTreeProvider;
import org.apache.drill.exec.store.ischema.InfoSchemaFilter;
import org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import org.apache.drill.exec.store.ischema.Records;
import org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.apache.drill.metastore.MetastoreRegistry;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ComparisonChain;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;
import org.apache.drill.shaded.guava.com.google.common.collect.Ordering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(MetadataProvider.class);
    private static final String IN_FUNCTION = "in";
    private static final String AND_FUNCTION = "booleanAnd".toLowerCase();
    private static final String OR_FUNCTION = "booleanOr".toLowerCase();

    public static Runnable catalogs(UserSession session, DrillbitContext dContext, UserProtos.GetCatalogsReq req, ResponseSender responseSender) {
        return new CatalogsProvider(session, dContext, req, responseSender);
    }

    public static Runnable schemas(UserSession session, DrillbitContext dContext, UserProtos.GetSchemasReq req, ResponseSender responseSender) {
        return new SchemasProvider(session, dContext, req, responseSender);
    }

    public static Runnable tables(UserSession session, DrillbitContext dContext, UserProtos.GetTablesReq req, ResponseSender responseSender) {
        return new TablesProvider(session, dContext, req, responseSender);
    }

    public static Runnable columns(UserSession session, DrillbitContext dContext, UserProtos.GetColumnsReq req, ResponseSender responseSender) {
        return new ColumnsProvider(session, dContext, req, responseSender);
    }

    private static InfoSchemaFilter createInfoSchemaFilter(UserProtos.LikeFilter catalogNameFilter, UserProtos.LikeFilter schemaNameFilter, UserProtos.LikeFilter tableNameFilter, List<String> tableTypeFilter, UserProtos.LikeFilter columnNameFilter) {
        InfoSchemaFilter.FunctionExprNode exprNode = MetadataProvider.createLikeFunctionExprNode("CATALOG_NAME", catalogNameFilter);
        if (schemaNameFilter != null) {
            UserProtos.LikeFilter.Builder builder = UserProtos.LikeFilter.newBuilder();
            if (schemaNameFilter.hasPattern()) {
                builder.setPattern(schemaNameFilter.getPattern().toLowerCase());
            }
            if (schemaNameFilter.hasEscape()) {
                builder.setEscape(schemaNameFilter.getEscape().toLowerCase());
            }
            schemaNameFilter = builder.build();
        }
        exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.combineFunctions(OR_FUNCTION, MetadataProvider.createLikeFunctionExprNode("TABLE_SCHEMA", schemaNameFilter), MetadataProvider.createLikeFunctionExprNode("SCHEMA_NAME", schemaNameFilter)));
        exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.createLikeFunctionExprNode("TABLE_NAME", tableNameFilter));
        exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.createInFunctionExprNode("TABLE_TYPE", tableTypeFilter));
        return (exprNode = MetadataProvider.combineFunctions(AND_FUNCTION, exprNode, MetadataProvider.createLikeFunctionExprNode("COLUMN_NAME", columnNameFilter))) != null ? new InfoSchemaFilter(exprNode) : null;
    }

    private static InfoSchemaFilter.FunctionExprNode createLikeFunctionExprNode(String fieldName, UserProtos.LikeFilter likeFilter) {
        if (likeFilter == null) {
            return null;
        }
        return new InfoSchemaFilter.FunctionExprNode("like", likeFilter.hasEscape() ? ImmutableList.of(new InfoSchemaFilter.FieldExprNode(fieldName), new InfoSchemaFilter.ConstantExprNode(likeFilter.getPattern()), new InfoSchemaFilter.ConstantExprNode(likeFilter.getEscape())) : ImmutableList.of(new InfoSchemaFilter.FieldExprNode(fieldName), new InfoSchemaFilter.ConstantExprNode(likeFilter.getPattern())));
    }

    private static InfoSchemaFilter.FunctionExprNode createInFunctionExprNode(String fieldName, List<String> valuesFilter) {
        if (valuesFilter == null) {
            return null;
        }
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add(new InfoSchemaFilter.FieldExprNode(fieldName));
        for (String type : valuesFilter) {
            nodes.add(new InfoSchemaFilter.ConstantExprNode(type));
        }
        return new InfoSchemaFilter.FunctionExprNode(IN_FUNCTION, (List<InfoSchemaFilter.ExprNode>)((Object)nodes.build()));
    }

    private static InfoSchemaFilter.FunctionExprNode combineFunctions(String functionName, InfoSchemaFilter.FunctionExprNode func1, InfoSchemaFilter.FunctionExprNode func2) {
        if (func1 == null) {
            return func2;
        }
        if (func2 == null) {
            return func1;
        }
        return new InfoSchemaFilter.FunctionExprNode(functionName, ImmutableList.of(func1, func2));
    }

    private static <S> PojoRecordReader<S> getPojoRecordReader(InfoSchemaTableType tableType, InfoSchemaFilter filter, DrillConfig config, SchemaTreeProvider provider, UserSession userSession, MetastoreRegistry metastoreRegistry) {
        SchemaPlus rootSchema = provider.createRootSchema(userSession.getCredentials().getUserName(), MetadataProvider.newSchemaConfigInfoProvider(config, userSession, provider));
        return tableType.getRecordReader(rootSchema, filter, userSession.getOptions(), metastoreRegistry);
    }

    private static SchemaConfig.SchemaConfigInfoProvider newSchemaConfigInfoProvider(final DrillConfig config, final UserSession session, final SchemaTreeProvider schemaTreeProvider) {
        return new SchemaConfig.SchemaConfigInfoProvider(){
            private final ViewExpansionContext viewExpansionContext;
            {
                this.viewExpansionContext = new ViewExpansionContext(config, this);
            }

            @Override
            public ViewExpansionContext getViewExpansionContext() {
                return this.viewExpansionContext;
            }

            @Override
            public SchemaPlus getRootSchema(String userName) {
                return schemaTreeProvider.createRootSchema(userName, this);
            }

            @Override
            public OptionValue getOption(String optionKey) {
                return session.getOptions().getOption(optionKey);
            }

            @Override
            public String getQueryUserName() {
                return session.getCredentials().getUserName();
            }

            @Override
            public UserBitShared.UserCredentials getQueryUserCredentials() {
                return session.getCredentials();
            }

            @Override
            public String getTemporaryTableName(String table) {
                return session.resolveTemporaryTableName(table);
            }

            @Override
            public String getTemporaryWorkspace() {
                return config.getString("drill.exec.default_temporary_workspace");
            }
        };
    }

    static UserBitShared.DrillPBError createPBError(String failedFunction, Throwable ex) {
        String errorId = UUID.randomUUID().toString();
        logger.error("Failed to {}. ErrorId: {}", new Object[]{failedFunction, errorId, ex});
        UserBitShared.DrillPBError.Builder builder = UserBitShared.DrillPBError.newBuilder();
        builder.setErrorType(UserBitShared.DrillPBError.ErrorType.SYSTEM);
        builder.setErrorId(errorId);
        if (ex.getMessage() != null) {
            builder.setMessage(ex.getMessage());
        }
        builder.setException(ErrorHelper.getWrapper(ex));
        return builder.build();
    }

    private static class CatalogsProvider
    extends MetadataRunnable {
        private static final Ordering<UserProtos.CatalogMetadata> CATALOGS_ORDERING = new Ordering<UserProtos.CatalogMetadata>(){

            @Override
            public int compare(UserProtos.CatalogMetadata left, UserProtos.CatalogMetadata right) {
                return Ordering.natural().compare(left.getCatalogName(), right.getCatalogName());
            }
        };
        private final UserProtos.GetCatalogsReq req;

        public CatalogsProvider(UserSession session, DrillbitContext dContext, UserProtos.GetCatalogsReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetCatalogsResp.Builder respBuilder = UserProtos.GetCatalogsResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, null, null, null, null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.CATALOGS, filter, this.getConfig(), schemaProvider, session, this.getMetastoreRegistry());
                ArrayList<UserProtos.CatalogMetadata> metadata = new ArrayList<UserProtos.CatalogMetadata>();
                for (Records.Catalog c : records) {
                    UserProtos.CatalogMetadata.Builder catBuilder = UserProtos.CatalogMetadata.newBuilder();
                    catBuilder.setCatalogName(c.CATALOG_NAME);
                    catBuilder.setDescription(c.CATALOG_DESCRIPTION);
                    catBuilder.setConnect(c.CATALOG_CONNECT);
                    metadata.add(catBuilder.build());
                }
                Collections.sort(metadata, CATALOGS_ORDERING);
                respBuilder.addAllCatalogs(metadata);
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get catalogs", e));
            }
            finally {
                return new Response(UserProtos.RpcType.CATALOGS, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static class SchemasProvider
    extends MetadataRunnable {
        private static final Ordering<UserProtos.SchemaMetadata> SCHEMAS_ORDERING = new Ordering<UserProtos.SchemaMetadata>(){

            @Override
            public int compare(UserProtos.SchemaMetadata left, UserProtos.SchemaMetadata right) {
                return ComparisonChain.start().compare((Comparable<?>)((Object)left.getCatalogName()), (Comparable<?>)((Object)right.getCatalogName())).compare((Comparable<?>)((Object)left.getSchemaName()), (Comparable<?>)((Object)right.getSchemaName())).result();
            }
        };
        private final UserProtos.GetSchemasReq req;

        private SchemasProvider(UserSession session, DrillbitContext dContext, UserProtos.GetSchemasReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetSchemasResp.Builder respBuilder = UserProtos.GetSchemasResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, this.req.hasSchemaNameFilter() ? this.req.getSchemaNameFilter() : null, null, null, null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.SCHEMATA, filter, this.getConfig(), schemaProvider, session, this.getMetastoreRegistry());
                ArrayList<UserProtos.SchemaMetadata> metadata = new ArrayList<UserProtos.SchemaMetadata>();
                for (Records.Schema s : records) {
                    UserProtos.SchemaMetadata.Builder schemaBuilder = UserProtos.SchemaMetadata.newBuilder();
                    schemaBuilder.setCatalogName(s.CATALOG_NAME);
                    schemaBuilder.setSchemaName(s.SCHEMA_NAME);
                    schemaBuilder.setOwner(s.SCHEMA_OWNER);
                    schemaBuilder.setType(s.TYPE);
                    schemaBuilder.setMutable(s.IS_MUTABLE);
                    metadata.add(schemaBuilder.build());
                }
                Collections.sort(metadata, SCHEMAS_ORDERING);
                respBuilder.addAllSchemas(metadata);
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get schemas", e));
            }
            finally {
                return new Response(UserProtos.RpcType.SCHEMAS, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static class TablesProvider
    extends MetadataRunnable {
        private static final Ordering<UserProtos.TableMetadata> TABLES_ORDERING = new Ordering<UserProtos.TableMetadata>(){

            @Override
            public int compare(UserProtos.TableMetadata left, UserProtos.TableMetadata right) {
                return ComparisonChain.start().compare((Comparable<?>)((Object)left.getType()), (Comparable<?>)((Object)right.getType())).compare((Comparable<?>)((Object)left.getCatalogName()), (Comparable<?>)((Object)right.getCatalogName())).compare((Comparable<?>)((Object)left.getSchemaName()), (Comparable<?>)((Object)right.getSchemaName())).compare((Comparable<?>)((Object)left.getTableName()), (Comparable<?>)((Object)right.getTableName())).result();
            }
        };
        private final UserProtos.GetTablesReq req;

        private TablesProvider(UserSession session, DrillbitContext dContext, UserProtos.GetTablesReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetTablesResp.Builder respBuilder = UserProtos.GetTablesResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, this.req.hasSchemaNameFilter() ? this.req.getSchemaNameFilter() : null, this.req.hasTableNameFilter() ? this.req.getTableNameFilter() : null, this.req.getTableTypeFilterCount() != 0 ? this.req.getTableTypeFilterList() : null, null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.TABLES, filter, this.getConfig(), schemaProvider, session, this.getMetastoreRegistry());
                ArrayList<UserProtos.TableMetadata> metadata = new ArrayList<UserProtos.TableMetadata>();
                for (Records.Table t : records) {
                    UserProtos.TableMetadata.Builder tableBuilder = UserProtos.TableMetadata.newBuilder();
                    tableBuilder.setCatalogName(t.TABLE_CATALOG);
                    tableBuilder.setSchemaName(t.TABLE_SCHEMA);
                    tableBuilder.setTableName(t.TABLE_NAME);
                    tableBuilder.setType(t.TABLE_TYPE);
                    metadata.add(tableBuilder.build());
                }
                Collections.sort(metadata, TABLES_ORDERING);
                respBuilder.addAllTables(metadata);
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get tables", e));
            }
            finally {
                return new Response(UserProtos.RpcType.TABLES, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static class ColumnsProvider
    extends MetadataRunnable {
        private static final Ordering<UserProtos.ColumnMetadata> COLUMNS_ORDERING = new Ordering<UserProtos.ColumnMetadata>(){

            @Override
            public int compare(UserProtos.ColumnMetadata left, UserProtos.ColumnMetadata right) {
                return ComparisonChain.start().compare((Comparable<?>)((Object)left.getCatalogName()), (Comparable<?>)((Object)right.getCatalogName())).compare((Comparable<?>)((Object)left.getSchemaName()), (Comparable<?>)((Object)right.getSchemaName())).compare((Comparable<?>)((Object)left.getTableName()), (Comparable<?>)((Object)right.getTableName())).compare(left.getOrdinalPosition(), right.getOrdinalPosition()).result();
            }
        };
        private final UserProtos.GetColumnsReq req;

        private ColumnsProvider(UserSession session, DrillbitContext dContext, UserProtos.GetColumnsReq req, ResponseSender responseSender) {
            super(session, dContext, responseSender);
            this.req = Preconditions.checkNotNull(req);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Response runInternal(UserSession session, SchemaTreeProvider schemaProvider) {
            UserProtos.GetColumnsResp.Builder respBuilder = UserProtos.GetColumnsResp.newBuilder();
            InfoSchemaFilter filter = MetadataProvider.createInfoSchemaFilter(this.req.hasCatalogNameFilter() ? this.req.getCatalogNameFilter() : null, this.req.hasSchemaNameFilter() ? this.req.getSchemaNameFilter() : null, this.req.hasTableNameFilter() ? this.req.getTableNameFilter() : null, null, this.req.hasColumnNameFilter() ? this.req.getColumnNameFilter() : null);
            try {
                PojoRecordReader records = MetadataProvider.getPojoRecordReader(InfoSchemaTableType.COLUMNS, filter, this.getConfig(), schemaProvider, session, this.getMetastoreRegistry());
                ArrayList<UserProtos.ColumnMetadata> metadata = new ArrayList<UserProtos.ColumnMetadata>();
                for (Records.Column c : records) {
                    UserProtos.ColumnMetadata.Builder columnBuilder = UserProtos.ColumnMetadata.newBuilder();
                    columnBuilder.setCatalogName(c.TABLE_CATALOG);
                    columnBuilder.setSchemaName(c.TABLE_SCHEMA);
                    columnBuilder.setTableName(c.TABLE_NAME);
                    columnBuilder.setColumnName(c.COLUMN_NAME);
                    columnBuilder.setOrdinalPosition(c.ORDINAL_POSITION);
                    if (c.COLUMN_DEFAULT != null) {
                        columnBuilder.setDefaultValue(c.COLUMN_DEFAULT);
                    }
                    if ("YES".equalsIgnoreCase(c.IS_NULLABLE)) {
                        columnBuilder.setIsNullable(true);
                    } else {
                        columnBuilder.setIsNullable(false);
                    }
                    columnBuilder.setDataType(c.DATA_TYPE);
                    if (c.CHARACTER_MAXIMUM_LENGTH != null) {
                        columnBuilder.setCharMaxLength(c.CHARACTER_MAXIMUM_LENGTH);
                    }
                    if (c.CHARACTER_OCTET_LENGTH != null) {
                        columnBuilder.setCharOctetLength(c.CHARACTER_OCTET_LENGTH);
                    }
                    if (c.NUMERIC_SCALE != null) {
                        columnBuilder.setNumericScale(c.NUMERIC_SCALE);
                    }
                    if (c.NUMERIC_PRECISION != null) {
                        columnBuilder.setNumericPrecision(c.NUMERIC_PRECISION);
                    }
                    if (c.NUMERIC_PRECISION_RADIX != null) {
                        columnBuilder.setNumericPrecisionRadix(c.NUMERIC_PRECISION_RADIX);
                    }
                    if (c.DATETIME_PRECISION != null) {
                        columnBuilder.setDateTimePrecision(c.DATETIME_PRECISION);
                    }
                    if (c.INTERVAL_TYPE != null) {
                        columnBuilder.setIntervalType(c.INTERVAL_TYPE);
                    }
                    if (c.INTERVAL_PRECISION != null) {
                        columnBuilder.setIntervalPrecision(c.INTERVAL_PRECISION);
                    }
                    if (c.COLUMN_SIZE != null) {
                        columnBuilder.setColumnSize(c.COLUMN_SIZE);
                    }
                    metadata.add(columnBuilder.build());
                }
                Collections.sort(metadata, COLUMNS_ORDERING);
                respBuilder.addAllColumns(metadata);
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable e) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("get columns", e));
            }
            finally {
                return new Response(UserProtos.RpcType.COLUMNS, respBuilder.build(), new ByteBuf[0]);
            }
        }
    }

    private static abstract class MetadataRunnable
    implements Runnable {
        protected final UserSession session;
        private final ResponseSender responseSender;
        private final DrillbitContext dContext;

        private MetadataRunnable(UserSession session, DrillbitContext dContext, ResponseSender responseSender) {
            this.session = Preconditions.checkNotNull(session);
            this.dContext = Preconditions.checkNotNull(dContext);
            this.responseSender = Preconditions.checkNotNull(responseSender);
        }

        @Override
        public void run() {
            try (SchemaTreeProvider schemaTreeProvider = new SchemaTreeProvider(this.dContext);){
                this.responseSender.send(this.runInternal(this.session, schemaTreeProvider));
            }
            catch (Throwable error) {
                logger.error("Unhandled metadata provider error", error);
            }
        }

        protected abstract Response runInternal(UserSession var1, SchemaTreeProvider var2);

        public DrillConfig getConfig() {
            return this.dContext.getConfig();
        }

        public MetastoreRegistry getMetastoreRegistry() {
            return this.dContext.getMetastoreRegistry();
        }
    }
}

