/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.metadata;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.resolver.TypeCastRules;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.metadata.MetadataProvider;
import org.apache.drill.shaded.guava.com.google.common.base.Splitter;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

public class ServerMetaProvider {
    private static final UserProtos.ServerMeta DEFAULT = UserProtos.ServerMeta.newBuilder().addAllConvertSupport(ServerMetaProvider.getSupportedConvertOps()).addAllDateTimeFunctions(Splitter.on(",").split(SqlJdbcFunctionCall.getTimeDateFunctions())).addAllDateTimeLiteralsSupport(Arrays.asList(UserProtos.DateTimeLiteralsSupport.values())).addAllNumericFunctions(Splitter.on(",").split(SqlJdbcFunctionCall.getNumericFunctions())).addAllOrderBySupport(Arrays.asList(UserProtos.OrderBySupport.OB_UNRELATED, UserProtos.OrderBySupport.OB_EXPRESSION)).addAllOuterJoinSupport(Arrays.asList(UserProtos.OuterJoinSupport.OJ_LEFT, UserProtos.OuterJoinSupport.OJ_RIGHT, UserProtos.OuterJoinSupport.OJ_FULL)).addAllStringFunctions(Splitter.on(",").split(SqlJdbcFunctionCall.getStringFunctions())).addAllSystemFunctions(Splitter.on(",").split(SqlJdbcFunctionCall.getSystemFunctions())).addAllSubquerySupport(Arrays.asList(UserProtos.SubQuerySupport.SQ_CORRELATED, UserProtos.SubQuerySupport.SQ_IN_COMPARISON, UserProtos.SubQuerySupport.SQ_IN_EXISTS, UserProtos.SubQuerySupport.SQ_IN_QUANTIFIED)).addAllUnionSupport(Arrays.asList(UserProtos.UnionSupport.U_UNION, UserProtos.UnionSupport.U_UNION_ALL)).setAllTablesSelectable(false).setBlobIncludedInMaxRowSize(true).setCatalogAtStart(true).setCatalogSeparator(".").setCatalogTerm("catalog").setColumnAliasingSupported(true).setNullPlusNonNullEqualsNull(true).setCorrelationNamesSupport(UserProtos.CorrelationNamesSupport.CN_ANY).setReadOnly(false).setGroupBySupport(UserProtos.GroupBySupport.GB_UNRELATED).setLikeEscapeClauseSupported(true).setNullCollation(UserProtos.NullCollation.NC_HIGH).setSchemaTerm("schema").setSearchEscapeString("\\").setTableTerm("table").build();

    private static Iterable<UserProtos.ConvertSupport> getSupportedConvertOps() {
        ImmutableList.Builder supportedConvertedOps = ImmutableList.builder();
        for (TypeProtos.MinorType from : TypeProtos.MinorType.values()) {
            for (TypeProtos.MinorType to : TypeProtos.MinorType.values()) {
                if (!TypeCastRules.isCastable(from, to)) continue;
                supportedConvertedOps.add(UserProtos.ConvertSupport.newBuilder().setFrom(from).setTo(to).build());
            }
        }
        return supportedConvertedOps.build();
    }

    public static class ServerMetaWorker
    implements Runnable {
        private final UserSession session;
        private final DrillbitContext context;
        private final UserProtos.GetServerMetaReq req;
        private final ResponseSender responseSender;

        public ServerMetaWorker(UserSession session, DrillbitContext context, UserProtos.GetServerMetaReq req, ResponseSender responseSender) {
            this.session = session;
            this.context = context;
            this.req = req;
            this.responseSender = responseSender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UserProtos.GetServerMetaResp.Builder respBuilder = UserProtos.GetServerMetaResp.newBuilder();
            try {
                UserProtos.ServerMeta.Builder metaBuilder = UserProtos.ServerMeta.newBuilder(DEFAULT);
                PlannerSettings plannerSettings = new PlannerSettings(this.session.getOptions(), this.context.getFunctionImplementationRegistry(), this.session.getCredentials().getUserName(), this.context.getAliasRegistryProvider());
                SqlParser.Config config = SqlParser.Config.DEFAULT.withIdentifierMaxLength((int)plannerSettings.getIdentifierMaxLength()).withQuoting(plannerSettings.getQuotingIdentifiers());
                int identifierMaxLength = config.identifierMaxLength();
                SqlAbstractParserImpl.Metadata metadata = SqlParser.create((String)"", (SqlParser.Config)config).getMetadata();
                metaBuilder.setMaxCatalogNameLength(identifierMaxLength).setMaxColumnNameLength(identifierMaxLength).setMaxCursorNameLength(identifierMaxLength).setMaxSchemaNameLength(identifierMaxLength).setMaxTableNameLength(identifierMaxLength).setMaxUserNameLength(identifierMaxLength).setIdentifierQuoteString(config.quoting().string).setIdentifierCasing(ServerMetaWorker.getIdentifierCasing(config.unquotedCasing(), config.caseSensitive())).setQuotedIdentifierCasing(ServerMetaWorker.getIdentifierCasing(config.quotedCasing(), config.caseSensitive())).addAllSqlKeywords(Splitter.on(",").split(metadata.getJdbcKeywords())).setCurrentSchema(this.session.getDefaultSchemaPath());
                respBuilder.setServerMeta(metaBuilder);
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
            }
            catch (Throwable t) {
                respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
                respBuilder.setError(MetadataProvider.createPBError("server meta", t));
            }
            finally {
                this.responseSender.send(new Response(UserProtos.RpcType.SERVER_META, respBuilder.build(), new ByteBuf[0]));
            }
        }

        public static UserProtos.IdentifierCasing getIdentifierCasing(Casing casing, boolean caseSensitive) {
            switch (casing) {
                case TO_LOWER: {
                    return UserProtos.IdentifierCasing.IC_STORES_LOWER;
                }
                case TO_UPPER: {
                    return UserProtos.IdentifierCasing.IC_STORES_UPPER;
                }
                case UNCHANGED: {
                    return caseSensitive ? UserProtos.IdentifierCasing.IC_SUPPORTS_MIXED : UserProtos.IdentifierCasing.IC_STORES_MIXED;
                }
            }
            throw new AssertionError((Object)("Unknown casing:" + (Object)((Object)casing)));
        }
    }
}

