/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.prepare;

import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import java.math.BigDecimal;
import java.net.SocketAddress;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.drill.common.exceptions.ErrorHelper;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.materialize.QueryDataPackage;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.rpc.AbstractDisposableUserClientConnection;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.UserClientConnection;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.work.user.UserWorker;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementProvider {
    private static final Logger logger = LoggerFactory.getLogger(PreparedStatementProvider.class);
    private static final Map<TypeProtos.MinorType, String> DRILL_TYPE_TO_JDBC_CLASSNAME = ImmutableMap.builder().put(TypeProtos.MinorType.INT, Integer.class.getName()).put(TypeProtos.MinorType.BIGINT, Long.class.getName()).put(TypeProtos.MinorType.FLOAT4, Float.class.getName()).put(TypeProtos.MinorType.FLOAT8, Double.class.getName()).put(TypeProtos.MinorType.VARCHAR, String.class.getName()).put(TypeProtos.MinorType.BIT, Boolean.class.getName()).put(TypeProtos.MinorType.DATE, Date.class.getName()).put(TypeProtos.MinorType.DECIMAL9, BigDecimal.class.getName()).put(TypeProtos.MinorType.DECIMAL18, BigDecimal.class.getName()).put(TypeProtos.MinorType.DECIMAL28SPARSE, BigDecimal.class.getName()).put(TypeProtos.MinorType.DECIMAL38SPARSE, BigDecimal.class.getName()).put(TypeProtos.MinorType.VARDECIMAL, BigDecimal.class.getName()).put(TypeProtos.MinorType.TIME, Time.class.getName()).put(TypeProtos.MinorType.TIMESTAMP, Timestamp.class.getName()).put(TypeProtos.MinorType.VARBINARY, byte[].class.getName()).put(TypeProtos.MinorType.INTERVAL, Period.class.getName()).put(TypeProtos.MinorType.INTERVALYEAR, Period.class.getName()).put(TypeProtos.MinorType.INTERVALDAY, Period.class.getName()).put(TypeProtos.MinorType.MAP, Object.class.getName()).put(TypeProtos.MinorType.LIST, Object.class.getName()).put(TypeProtos.MinorType.UNION, Object.class.getName()).build();

    private static void setErrorHelper(UserProtos.CreatePreparedStatementResp.Builder respBuilder, UserProtos.RequestStatus status, Throwable ex, String message, UserBitShared.DrillPBError.ErrorType errorType) {
        respBuilder.setStatus(status);
        String errorId = UUID.randomUUID().toString();
        if (ex != null) {
            logger.error("{} ErrorId: {}", new Object[]{message, errorId, ex});
        } else {
            logger.error("{} ErrorId: {}", (Object)message, (Object)errorId);
        }
        UserBitShared.DrillPBError.Builder builder = UserBitShared.DrillPBError.newBuilder();
        builder.setErrorType(errorType);
        builder.setErrorId(errorId);
        builder.setMessage(message);
        if (ex != null) {
            builder.setException(ErrorHelper.getWrapper(ex));
        }
        respBuilder.setError(builder.build());
    }

    private static void setErrorHelper(UserProtos.CreatePreparedStatementResp.Builder respBuilder, UserBitShared.DrillPBError error, String message) {
        respBuilder.setStatus(UserProtos.RequestStatus.FAILED);
        String errorId = UUID.randomUUID().toString();
        logger.error("{} ErrorId: {}", (Object)message, (Object)errorId);
        respBuilder.setError(error);
    }

    private static UserProtos.ResultColumnMetadata serializeColumn(UserBitShared.SerializedField field) {
        UserProtos.ResultColumnMetadata.Builder builder = UserProtos.ResultColumnMetadata.newBuilder();
        TypeProtos.MajorType majorType = field.getMajorType();
        TypeProtos.MinorType minorType = majorType.getMinorType();
        builder.setCatalogName("DRILL");
        builder.setSchemaName("");
        builder.setTableName("");
        builder.setColumnName(field.getNamePart().getName());
        builder.setLabel(field.getNamePart().getName());
        builder.setDataType(Types.getSqlTypeName(majorType));
        builder.setIsNullable(majorType.getMode() == TypeProtos.DataMode.OPTIONAL);
        builder.setPrecision(Types.getPrecision(field.getMajorType()));
        builder.setScale(Types.getScale(majorType));
        builder.setSigned(Types.isNumericType(majorType));
        builder.setDisplaySize(Types.getJdbcDisplaySize(majorType));
        builder.setIsAliased(true);
        builder.setSearchability(UserProtos.ColumnSearchability.ALL);
        builder.setUpdatability(UserProtos.ColumnUpdatability.READ_ONLY);
        builder.setAutoIncrement(false);
        builder.setCaseSensitivity(false);
        builder.setSortable(Types.isSortable(minorType));
        builder.setClassName(DRILL_TYPE_TO_JDBC_CLASSNAME.get(minorType));
        builder.setIsCurrency(false);
        return builder.build();
    }

    private static class UserClientConnectionWrapper
    extends AbstractDisposableUserClientConnection {
        private final UserClientConnection inner;
        private volatile List<UserBitShared.SerializedField> fields;

        UserClientConnectionWrapper(UserClientConnection inner) {
            this.inner = inner;
        }

        @Override
        public UserSession getSession() {
            return this.inner.getSession();
        }

        @Override
        public Future<Void> getClosureFuture() {
            return this.inner.getClosureFuture();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return this.inner.getRemoteAddress();
        }

        @Override
        public void sendData(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, QueryDataPackage data) {
            VectorContainer batch = data.batch();
            if (batch != null) {
                if (this.fields == null) {
                    this.fields = data.fields();
                }
                batch.zeroVectors();
            }
            listener.success(Acks.OK, null);
        }

        public List<UserBitShared.SerializedField> getFields() {
            return this.fields;
        }
    }

    public static class PreparedStatementWorker
    implements Runnable {
        private final UserClientConnection connection;
        private final UserWorker userWorker;
        private final ResponseSender responseSender;
        private final UserProtos.CreatePreparedStatementReq req;

        public PreparedStatementWorker(UserClientConnection connection, UserWorker userWorker, ResponseSender responseSender, UserProtos.CreatePreparedStatementReq req) {
            this.connection = connection;
            this.userWorker = userWorker;
            this.responseSender = responseSender;
            this.req = req;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            UserProtos.CreatePreparedStatementResp.Builder respBuilder = UserProtos.CreatePreparedStatementResp.newBuilder();
            try {
                UserClientConnectionWrapper wrapper = new UserClientConnectionWrapper(this.connection);
                UserProtos.RunQuery limit0Query = UserProtos.RunQuery.newBuilder().setType(UserBitShared.QueryType.SQL).setPlan(String.format("SELECT * FROM (%s) LIMIT 0", this.req.getSqlQuery())).build();
                UserBitShared.QueryId limit0QueryId = this.userWorker.submitWork(wrapper, limit0Query);
                long timeoutMillis = this.userWorker.getSystemOptions().getOption((String)"prepare.statement.create_timeout_ms").num_val;
                try {
                    if (!wrapper.await(timeoutMillis)) {
                        logger.error("LIMIT 0 query (QueryId: {}) for prepared statement took longer than {} ms. Cancelling.", (Object)limit0QueryId, (Object)timeoutMillis);
                        this.userWorker.cancelQuery(limit0QueryId);
                        String errorMsg = String.format("LIMIT 0 query (QueryId: %s) for prepared statement took longer than %d ms. Query cancellation requested.\nRetry after changing the option '%s' to a higher value.", limit0QueryId, timeoutMillis, "prepare.statement.create_timeout_ms");
                        PreparedStatementProvider.setErrorHelper(respBuilder, UserProtos.RequestStatus.TIMEOUT, null, errorMsg, UserBitShared.DrillPBError.ErrorType.SYSTEM);
                        return;
                    }
                }
                catch (InterruptedException ex) {
                    PreparedStatementProvider.setErrorHelper(respBuilder, UserProtos.RequestStatus.FAILED, ex, "Prepared statement creation interrupted.", UserBitShared.DrillPBError.ErrorType.SYSTEM);
                    return;
                }
                if (wrapper.getError() != null) {
                    PreparedStatementProvider.setErrorHelper(respBuilder, wrapper.getError(), "Failed to get result set schema for prepare statement.");
                    return;
                }
                UserProtos.PreparedStatement.Builder prepStmtBuilder = UserProtos.PreparedStatement.newBuilder();
                for (UserBitShared.SerializedField field : wrapper.getFields()) {
                    prepStmtBuilder.addColumns(PreparedStatementProvider.serializeColumn(field));
                }
                prepStmtBuilder.setServerHandle(UserProtos.PreparedStatementHandle.newBuilder().setServerInfo(ExecProtos.ServerPreparedStatementState.newBuilder().setSqlQuery(this.req.getSqlQuery()).build().toByteString()));
                respBuilder.setStatus(UserProtos.RequestStatus.OK);
                respBuilder.setPreparedStatement(prepStmtBuilder.build());
            }
            catch (Throwable e) {
                PreparedStatementProvider.setErrorHelper(respBuilder, UserProtos.RequestStatus.FAILED, e, "Failed to create prepared statement.", UserBitShared.DrillPBError.ErrorType.SYSTEM);
            }
            finally {
                this.responseSender.send(new Response(UserProtos.RpcType.PREPARED_STATEMENT, respBuilder.build(), new ByteBuf[0]));
            }
        }
    }
}

