/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.components.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;

public class BasicTablesTransformer {
    public static List<BaseTableMetadata> tables(List<TableMetadataUnit> units) {
        return units.stream().filter(unit -> MetadataType.TABLE == MetadataType.fromValue(unit.metadataType())).map(unit -> ((BaseTableMetadata.BaseTableMetadataBuilder)BaseTableMetadata.builder().metadataUnit((TableMetadataUnit)unit)).build()).collect(Collectors.toList());
    }

    public static List<SegmentMetadata> segments(List<TableMetadataUnit> units) {
        return units.stream().filter(unit -> MetadataType.SEGMENT == MetadataType.fromValue(unit.metadataType())).map(unit -> ((SegmentMetadata.SegmentMetadataBuilder)SegmentMetadata.builder().metadataUnit((TableMetadataUnit)unit)).build()).collect(Collectors.toList());
    }

    public static List<FileMetadata> files(List<TableMetadataUnit> units) {
        return units.stream().filter(unit -> MetadataType.FILE == MetadataType.fromValue(unit.metadataType())).map(unit -> ((FileMetadata.FileMetadataBuilder)FileMetadata.builder().metadataUnit((TableMetadataUnit)unit)).build()).collect(Collectors.toList());
    }

    public static List<RowGroupMetadata> rowGroups(List<TableMetadataUnit> units) {
        return units.stream().filter(unit -> MetadataType.ROW_GROUP == MetadataType.fromValue(unit.metadataType())).map(unit -> ((RowGroupMetadata.RowGroupMetadataBuilder)RowGroupMetadata.builder().metadataUnit((TableMetadataUnit)unit)).build()).collect(Collectors.toList());
    }

    public static List<PartitionMetadata> partitions(List<TableMetadataUnit> units) {
        return units.stream().filter(unit -> MetadataType.PARTITION == MetadataType.fromValue(unit.metadataType())).map(unit -> ((PartitionMetadata.PartitionMetadataBuilder)PartitionMetadata.builder().metadataUnit((TableMetadataUnit)unit)).build()).collect(Collectors.toList());
    }

    public static MetadataHolder all(List<TableMetadataUnit> units) {
        ArrayList<BaseTableMetadata> tables = new ArrayList<BaseTableMetadata>();
        ArrayList<SegmentMetadata> segments = new ArrayList<SegmentMetadata>();
        ArrayList<FileMetadata> files = new ArrayList<FileMetadata>();
        ArrayList<RowGroupMetadata> rowGroups = new ArrayList<RowGroupMetadata>();
        ArrayList<PartitionMetadata> partitions = new ArrayList<PartitionMetadata>();
        for (TableMetadataUnit unit : units) {
            MetadataType metadataType = MetadataType.fromValue(unit.metadataType());
            if (metadataType == null) continue;
            switch (metadataType) {
                case TABLE: {
                    tables.add(((BaseTableMetadata.BaseTableMetadataBuilder)BaseTableMetadata.builder().metadataUnit(unit)).build());
                    break;
                }
                case SEGMENT: {
                    segments.add(((SegmentMetadata.SegmentMetadataBuilder)SegmentMetadata.builder().metadataUnit(unit)).build());
                    break;
                }
                case FILE: {
                    files.add(((FileMetadata.FileMetadataBuilder)FileMetadata.builder().metadataUnit(unit)).build());
                    break;
                }
                case ROW_GROUP: {
                    rowGroups.add(((RowGroupMetadata.RowGroupMetadataBuilder)RowGroupMetadata.builder().metadataUnit(unit)).build());
                    break;
                }
                case PARTITION: {
                    partitions.add(((PartitionMetadata.PartitionMetadataBuilder)PartitionMetadata.builder().metadataUnit(unit)).build());
                    break;
                }
            }
        }
        return new MetadataHolder(tables, segments, files, rowGroups, partitions);
    }

    public static class MetadataHolder {
        private final List<BaseTableMetadata> tables;
        private final List<SegmentMetadata> segments;
        private final List<FileMetadata> files;
        private final List<RowGroupMetadata> rowGroups;
        private final List<PartitionMetadata> partitions;

        public MetadataHolder(List<BaseTableMetadata> tables, List<SegmentMetadata> segments, List<FileMetadata> files, List<RowGroupMetadata> rowGroups, List<PartitionMetadata> partitions) {
            this.tables = tables;
            this.segments = segments;
            this.files = files;
            this.rowGroups = rowGroups;
            this.partitions = partitions;
        }

        public List<BaseTableMetadata> tables() {
            return this.tables;
        }

        public List<SegmentMetadata> segments() {
            return this.segments;
        }

        public List<FileMetadata> files() {
            return this.files;
        }

        public List<RowGroupMetadata> rowGroups() {
            return this.rowGroups;
        }

        public List<PartitionMetadata> partitions() {
            return this.partitions;
        }
    }
}

