/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.components.tables;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.TableInfo;

public class MetastoreTableInfo {
    private final TableInfo tableInfo;
    private final Long lastModifiedTime;
    private final boolean exists;
    private final long metastoreVersion;

    @JsonCreator
    public MetastoreTableInfo(@JsonProperty(value="tableInfo") TableInfo tableInfo, @JsonProperty(value="lastModifiedTime") Long lastModifiedTime, @JsonProperty(value="exists") boolean exists, @JsonProperty(value="metastoreVersion") long metastoreVersion) {
        this.tableInfo = tableInfo;
        this.lastModifiedTime = lastModifiedTime;
        this.exists = exists;
        this.metastoreVersion = metastoreVersion;
    }

    public static MetastoreTableInfo of(TableInfo tableInfo, TableMetadataUnit unit, long metastoreVersion) {
        boolean exists = unit != null;
        Long lastModifiedTime = exists ? unit.lastModifiedTime() : null;
        return new MetastoreTableInfo(tableInfo, lastModifiedTime, exists, metastoreVersion);
    }

    @JsonProperty
    public TableInfo tableInfo() {
        return this.tableInfo;
    }

    @JsonProperty
    public Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    @JsonProperty
    public boolean isExists() {
        return this.exists;
    }

    @JsonProperty
    public long metastoreVersion() {
        return this.metastoreVersion;
    }

    public boolean hasChanged(boolean currentExists, Long currentLastModifiedTime) {
        if (this.exists && currentExists) {
            return !Objects.equals(this.lastModifiedTime, currentLastModifiedTime);
        }
        return this.exists || currentExists;
    }

    public int hashCode() {
        return Objects.hash(this.tableInfo, this.lastModifiedTime, this.exists, this.metastoreVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetastoreTableInfo that = (MetastoreTableInfo)o;
        return this.exists == that.exists && this.metastoreVersion == that.metastoreVersion && Objects.equals(this.tableInfo, that.tableInfo) && Objects.equals(this.lastModifiedTime, that.lastModifiedTime);
    }

    public String toString() {
        return new StringJoiner(", ", MetastoreTableInfo.class.getSimpleName() + "[", "]").add("tableInfo=" + this.tableInfo).add("lastModifiedTime=" + this.lastModifiedTime).add("exists=" + this.exists).add("metastoreVersion=" + this.metastoreVersion).toString();
    }
}

