/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.operate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.operate.MetadataTypeValidator;
import org.apache.drill.metastore.operate.Read;

public abstract class AbstractRead<T>
implements Read<T> {
    protected final Set<MetadataType> metadataTypes = new HashSet<MetadataType>();
    protected final List<MetastoreColumn> columns = new ArrayList<MetastoreColumn>();
    protected FilterExpression filter;
    private final MetadataTypeValidator metadataTypeValidator;

    protected AbstractRead(MetadataTypeValidator metadataTypeValidator) {
        this.metadataTypeValidator = metadataTypeValidator;
    }

    @Override
    public Read<T> metadataTypes(Set<MetadataType> metadataTypes) {
        this.metadataTypes.addAll(metadataTypes);
        return this;
    }

    @Override
    public Read<T> filter(FilterExpression filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public Read<T> columns(List<MetastoreColumn> columns) {
        this.columns.addAll(columns);
        return this;
    }

    @Override
    public final List<T> execute() {
        this.metadataTypeValidator.validate(this.metadataTypes);
        return this.internalExecute();
    }

    protected abstract List<T> internalExecute();
}

