/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.statistics;

import java.util.Comparator;
import java.util.List;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.CollectableColumnStatisticsKind;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.statistics.Histogram;

public class ColumnStatisticsKind<T>
extends BaseStatisticsKind<T>
implements CollectableColumnStatisticsKind<T> {
    public static final ColumnStatisticsKind<Long> NULLS_COUNT = new ColumnStatisticsKind<Long>("nullsCount", true){

        @Override
        public Long mergeStatistics(List<? extends ColumnStatistics<?>> statisticsList) {
            long nullsCount = 0L;
            for (ColumnStatistics<?> statistics : statisticsList) {
                Long statNullsCount = statistics.get(this);
                if (statNullsCount == null || statNullsCount == -1L) {
                    return -1L;
                }
                nullsCount += statNullsCount.longValue();
            }
            return nullsCount;
        }

        @Override
        public Long getFrom(ColumnStatistics<?> metadata) {
            Long rowCount = (Long)super.getFrom(metadata);
            return rowCount != null ? rowCount : -1L;
        }
    };
    public static final ColumnStatisticsKind<Object> MIN_VALUE = new ColumnStatisticsKind<Object>("minValue", true){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics<?>> statisticsList) {
            Object minValue = null;
            for (ColumnStatistics<?> statistics : statisticsList) {
                Object statMinValue = this.getValueStatistic(statistics);
                Comparator<?> comp = statistics.getValueComparator();
                if (statMinValue == null || comp.compare(minValue, statMinValue) <= 0 && minValue != null) continue;
                minValue = statMinValue;
            }
            return minValue;
        }
    };
    public static final ColumnStatisticsKind<Object> MAX_VALUE = new ColumnStatisticsKind<Object>("maxValue", true){

        @Override
        public Object mergeStatistics(List<? extends ColumnStatistics<?>> statisticsList) {
            Object maxValue = null;
            for (ColumnStatistics<?> statistics : statisticsList) {
                Object statMaxValue = this.getValueStatistic(statistics);
                Comparator<?> comp = statistics.getValueComparator();
                if (statMaxValue == null || comp.compare(maxValue, statMaxValue) >= 0) continue;
                maxValue = statMaxValue;
            }
            return maxValue;
        }
    };
    public static final ColumnStatisticsKind<Long> NON_NULL_VALUES_COUNT = new ColumnStatisticsKind<Long>("nonNullValuesCount", true){

        @Override
        public Long mergeStatistics(List<? extends ColumnStatistics<?>> statisticsList) {
            long nonNullRowCount = 0L;
            for (ColumnStatistics<?> statistics : statisticsList) {
                Long nnRowCount = statistics.get(this);
                if (nnRowCount == null) continue;
                nonNullRowCount += nnRowCount.longValue();
            }
            return nonNullRowCount;
        }
    };
    public static final ColumnStatisticsKind<Double> NON_NULL_COUNT = new ColumnStatisticsKind<Double>("nonnullrowcount", false){

        @Override
        public Double mergeStatistics(List<? extends ColumnStatistics<?>> statisticsList) {
            double nonNullRowCount = 0.0;
            for (ColumnStatistics<?> statistics : statisticsList) {
                Double nnRowCount = statistics.get(this);
                if (nnRowCount == null) continue;
                nonNullRowCount += nnRowCount.doubleValue();
            }
            return nonNullRowCount;
        }
    };
    public static final ColumnStatisticsKind<Double> ROWCOUNT = new ColumnStatisticsKind<Double>("rowcount", false){

        @Override
        public Double mergeStatistics(List<? extends ColumnStatistics<?>> statisticsList) {
            double rowCount = 0.0;
            for (ColumnStatistics<?> statistics : statisticsList) {
                Double count = (Double)this.getFrom(statistics);
                if (count == null) continue;
                rowCount += count.doubleValue();
            }
            return rowCount;
        }
    };
    public static final ColumnStatisticsKind<Double> NDV = new ColumnStatisticsKind("approx_count_distinct", false);
    public static final ColumnStatisticsKind<?> AVG_WIDTH = new ColumnStatisticsKind("avg_width", false);
    public static final ColumnStatisticsKind<Histogram> HISTOGRAM = new ColumnStatisticsKind("histogram", false);

    ColumnStatisticsKind(String statisticKey, boolean exact) {
        super(statisticKey, exact);
    }

    public T getFrom(ColumnStatistics<?> metadata) {
        return (T)metadata.get(this);
    }

    public <V> V getValueStatistic(ColumnStatistics<V> metadata) {
        return metadata.get(this);
    }

    @Override
    public T mergeStatistics(List<? extends ColumnStatistics<?>> statistics) {
        throw new UnsupportedOperationException("Cannot merge statistics for " + this.statisticKey);
    }
}

