/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.eventadmin;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.eventadmin.EventAdminEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAdminConsumer
extends DefaultConsumer
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EventAdminConsumer.class);
    private final EventAdminEndpoint endpoint;
    private ServiceRegistration<?> registration;

    public EventAdminConsumer(EventAdminEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void handleEvent(Event event) {
        Exchange exchange = this.endpoint.createExchange();
        exchange.getIn().setBody((Object)event);
        LOG.trace("EventAdmin {} is firing", (Object)this.endpoint.getTopic());
        try {
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", this.endpoint.getTopic());
        this.registration = this.endpoint.getComponent().getBundleContext().registerService(EventHandler.class.getName(), (Object)this, props);
    }

    protected void doStop() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        super.doStop();
    }
}

