/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flowable;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.flowable.FlowableConsumer;
import org.apache.camel.component.flowable.FlowableProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.model.CamelInboundChannelModel;
import org.flowable.eventregistry.model.CamelOutboundChannelModel;

@UriEndpoint(firstVersion="4.9.0", scheme="flowable", title="Flowable", syntax="flowable:channelKey", category={Category.WORKFLOW})
public class FlowableEndpoint
extends DefaultEndpoint {
    private EventRegistryEngineConfiguration eventRegistryEngineConfiguration;
    private FlowableConsumer flowableConsumer;
    @UriPath
    @Metadata(required=true)
    private String channelKey;
    private CamelInboundChannelModel camelInboundChannel;
    private CamelOutboundChannelModel camelOutboundChannel;

    public FlowableEndpoint(String channelKey) {
        this.channelKey = channelKey;
    }

    public FlowableEndpoint(CamelInboundChannelModel camelInboundChannel, EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        this.camelInboundChannel = camelInboundChannel;
        this.eventRegistryEngineConfiguration = eventRegistryEngineConfiguration;
    }

    public FlowableEndpoint(CamelOutboundChannelModel camelOutboundChannel, EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        this.camelOutboundChannel = camelOutboundChannel;
        this.eventRegistryEngineConfiguration = eventRegistryEngineConfiguration;
    }

    public void process(Exchange ex) throws Exception {
        if (this.flowableConsumer == null) {
            throw new FlowableException("Consumer not defined for " + this.getEndpointUri());
        }
        this.flowableConsumer.getProcessor().process(ex);
    }

    public Producer createProducer() throws Exception {
        return new FlowableProducer(this.camelInboundChannel, (Endpoint)this, this.eventRegistryEngineConfiguration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new FlowableConsumer(this, processor);
    }

    protected String createEndpointUri() {
        if (this.channelKey != null) {
            return "flowable:" + this.channelKey;
        }
        if (this.camelInboundChannel != null) {
            return "flowable:" + this.camelInboundChannel.getKey();
        }
        return "flowable:" + this.camelOutboundChannel.getKey();
    }

    protected void addConsumer(FlowableConsumer consumer) {
        if (this.flowableConsumer != null) {
            throw new FlowableException("Consumer already defined for " + this.getEndpointUri() + "!");
        }
        this.flowableConsumer = consumer;
    }

    protected void removeConsumer() {
        this.flowableConsumer = null;
    }

    public String getChannelKey() {
        return this.channelKey;
    }

    public void setChannelKey(String channelKey) {
        this.channelKey = channelKey;
    }

    public void setCamelInboundChannel(CamelInboundChannelModel camelInboundChannel) {
        this.camelInboundChannel = camelInboundChannel;
    }

    public void setCamelOutboundChannel(CamelOutboundChannelModel camelOutboundChannel) {
        this.camelOutboundChannel = camelOutboundChannel;
    }

    public void setEventRegistryEngineConfiguration(EventRegistryEngineConfiguration eventRegistryEngineConfiguration) {
        this.eventRegistryEngineConfiguration = eventRegistryEngineConfiguration;
    }
}

