/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc;

import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;

public final class GrpcUtils {
    private GrpcUtils() {
    }

    public static String extractServiceName(String service) {
        return service.contains(".") ? service.substring(service.lastIndexOf(46) + 1) : service;
    }

    public static String extractServicePackage(String service) {
        return service.contains(".") ? service.substring(0, service.lastIndexOf(46)) : "";
    }

    public static Object constructGrpcAsyncStub(String packageName, String serviceName, Channel channel, CallCredentials creds, CamelContext context) {
        return GrpcUtils.constructGrpcStubClass(packageName, serviceName, "newStub", channel, creds, context);
    }

    public static Object constructGrpcBlockingStub(String packageName, String serviceName, Channel channel, CallCredentials creds, CamelContext context) {
        return GrpcUtils.constructGrpcStubClass(packageName, serviceName, "newBlockingStub", channel, creds, context);
    }

    private static Object constructGrpcStubClass(String packageName, String serviceName, String stubMethod, Channel channel, CallCredentials creds, CamelContext context) {
        Class[] paramChannel = new Class[]{Channel.class};
        Object grpcStub = null;
        String serviceClassName = GrpcUtils.constructFullClassName(packageName, serviceName + "Grpc");
        try {
            Class grpcServiceClass = context.getClassResolver().resolveMandatoryClass(serviceClassName);
            Method grpcMethod = ReflectionHelper.findMethod((Class)grpcServiceClass, (String)stubMethod, (Class[])paramChannel);
            if (grpcMethod == null) {
                throw new IllegalArgumentException("gRPC service method not found: " + serviceClassName + "." + stubMethod);
            }
            grpcStub = org.apache.camel.support.ObjectHelper.invokeMethod((Method)grpcMethod, (Object)grpcServiceClass, (Object[])new Object[]{channel});
            if (creds != null) {
                return GrpcUtils.addClientCallCredentials(grpcStub, creds);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("gRPC service class not found: " + serviceClassName);
        }
        return grpcStub;
    }

    public static Object addClientCallCredentials(Object grpcStub, CallCredentials creds) {
        Class[] paramCallCreds = new Class[]{CallCredentials.class};
        Object grpcStubWithCreds = null;
        Method callCredsMethod = ReflectionHelper.findMethod(grpcStub.getClass(), (String)"withCallCredentials", (Class[])paramCallCreds);
        grpcStubWithCreds = org.apache.camel.support.ObjectHelper.invokeMethod((Method)callCredsMethod, (Object)grpcStub, (Object[])new Object[]{creds});
        return grpcStubWithCreds;
    }

    public static Class constructGrpcImplBaseClass(String packageName, String serviceName, CamelContext context) {
        Class grpcServerImpl;
        String serverBaseImpl = GrpcUtils.constructFullClassName(packageName, serviceName + "Grpc$" + serviceName + "ImplBase");
        try {
            grpcServerImpl = context.getClassResolver().resolveMandatoryClass(serverBaseImpl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("gRPC server base class not found: " + serverBaseImpl);
        }
        return grpcServerImpl;
    }

    public static void invokeAsyncMethod(Object asyncStubClass, String invokeMethod, Object request, StreamObserver responseObserver) {
        Class[] paramMethod = null;
        Method method = ReflectionHelper.findMethod(asyncStubClass.getClass(), (String)invokeMethod, paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + asyncStubClass.getClass().getName() + "." + invokeMethod);
        }
        if (method.getReturnType().equals(StreamObserver.class)) {
            StreamObserver requestObserver = (StreamObserver)org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)asyncStubClass, (Object[])new Object[]{responseObserver});
            if (request instanceof List) {
                List requestList = (List)request;
                requestList.forEach(arg_0 -> ((StreamObserver)requestObserver).onNext(arg_0));
            } else {
                requestObserver.onNext(request);
            }
            requestObserver.onCompleted();
        } else {
            org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)asyncStubClass, (Object[])new Object[]{request, responseObserver});
        }
    }

    public static StreamObserver<Object> invokeAsyncMethodStreaming(Object asyncStubClass, String invokeMethod, StreamObserver<?> responseObserver) {
        Class[] paramMethod = null;
        Method method = ReflectionHelper.findMethod(asyncStubClass.getClass(), (String)invokeMethod, paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + asyncStubClass.getClass().getName() + "." + invokeMethod);
        }
        if (!StreamObserver.class.isAssignableFrom(method.getReturnType())) {
            throw new IllegalArgumentException("gRPC service method does not declare an input of type stream (cannot be used in streaming mode): " + asyncStubClass.getClass().getName() + "." + invokeMethod);
        }
        return (StreamObserver)org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)asyncStubClass, (Object[])new Object[]{responseObserver});
    }

    public static Object invokeSyncMethod(Object blockingStubClass, String invokeMethod, Object request) {
        Class[] paramMethod = null;
        Method method = ReflectionHelper.findMethod(blockingStubClass.getClass(), (String)invokeMethod, paramMethod);
        if (method == null) {
            throw new IllegalArgumentException("gRPC service method not found: " + blockingStubClass.getClass().getName() + "." + invokeMethod);
        }
        if (method.getReturnType().equals(Iterator.class)) {
            Iterator responseObjects = (Iterator)org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)blockingStubClass, (Object[])new Object[]{request});
            ArrayList objectList = new ArrayList();
            while (responseObjects.hasNext()) {
                objectList.add(responseObjects.next());
            }
            return objectList;
        }
        return org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)blockingStubClass, (Object[])new Object[]{request});
    }

    public static String convertMethod2CamelCase(String method) {
        StringBuilder sb = new StringBuilder(method.length());
        sb.append(method.substring(0, 1).toLowerCase());
        boolean afterUnderscore = false;
        for (int i = 1; i < method.length(); ++i) {
            if (method.charAt(i) == '_') {
                afterUnderscore = true;
                continue;
            }
            sb.append(afterUnderscore ? Character.toUpperCase(method.charAt(i)) : method.charAt(i));
            afterUnderscore = false;
        }
        return sb.toString();
    }

    private static String constructFullClassName(String packageName, String className) {
        if (ObjectHelper.isEmpty((String)packageName)) {
            return className;
        }
        return packageName + "." + className;
    }
}

