/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.obs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.huaweicloud.obs.OBSEndpoint;
import org.apache.camel.component.huaweicloud.obs.OBSUtils;
import org.apache.camel.component.huaweicloud.obs.models.ClientConfigurations;
import org.apache.camel.component.huaweicloud.obs.models.OBSRegion;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBSProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OBSProducer.class);
    private OBSEndpoint endpoint;
    private ObsClient obsClient;
    private Gson gson;

    public OBSProducer(OBSEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.gson = new Gson();
    }

    public void process(Exchange exchange) throws Exception {
        ClientConfigurations clientConfigurations = new ClientConfigurations();
        if (this.obsClient == null) {
            this.obsClient = this.endpoint.initClient();
        }
        this.updateClientConfigs(exchange, clientConfigurations);
        switch (clientConfigurations.getOperation()) {
            case "listBuckets": {
                this.listBuckets(exchange);
                break;
            }
            case "createBucket": {
                this.createBucket(exchange, clientConfigurations);
                break;
            }
            case "deleteBucket": {
                this.deleteBucket(exchange, clientConfigurations);
                break;
            }
            case "checkBucketExists": {
                this.checkBucketExists(exchange, clientConfigurations);
                break;
            }
            case "getBucketMetadata": {
                this.getBucketMetadata(exchange, clientConfigurations);
                break;
            }
            case "listObjects": {
                this.listObjects(exchange, clientConfigurations);
                break;
            }
            case "getObject": {
                this.getObject(exchange, clientConfigurations);
                break;
            }
            case "putObject": {
                this.putObject(exchange, clientConfigurations);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("%s is not a supported operation", clientConfigurations.getOperation()));
            }
        }
    }

    private void putObject(Exchange exchange, ClientConfigurations clientConfigurations) throws IOException {
        Object body = exchange.getMessage().getBody();
        if ((ObjectHelper.isEmpty((String)clientConfigurations.getBucketName()) || ObjectHelper.isEmpty((String)clientConfigurations.getObjectName())) && !(body instanceof File)) {
            throw new IllegalArgumentException("Bucket and object names are mandatory to put objects into bucket");
        }
        LOG.trace("Checking if bucket {} exists", (Object)clientConfigurations.getBucketName());
        if (!this.obsClient.headBucket(clientConfigurations.getBucketName())) {
            LOG.warn("No bucket found with name {}. Attempting to create", (Object)clientConfigurations.getBucketName());
            OBSRegion.checkValidRegion(clientConfigurations.getBucketLocation());
            CreateBucketRequest request = new CreateBucketRequest(clientConfigurations.getBucketName(), clientConfigurations.getBucketLocation());
            this.obsClient.createBucket(request);
            LOG.warn("Bucket with name {} created. Continuing to upload object into it", (Object)request.getBucketName());
        }
        PutObjectResult putObjectResult = null;
        if (body instanceof File) {
            LOG.trace("Exchange payload is of type File");
            String objectName = ObjectHelper.isEmpty((String)clientConfigurations.getObjectName()) ? ((File)body).getName() : clientConfigurations.getObjectName();
            putObjectResult = this.obsClient.putObject(clientConfigurations.getBucketName(), objectName, (File)body);
        } else if (body instanceof String) {
            LOG.trace("Writing text body into an object");
            ByteArrayInputStream stream = new ByteArrayInputStream(((String)body).getBytes());
            putObjectResult = this.obsClient.putObject(clientConfigurations.getBucketName(), clientConfigurations.getObjectName(), (InputStream)stream);
            ((InputStream)stream).close();
        } else if (body instanceof InputStream) {
            LOG.trace("Exchange payload is of type InputStream");
            putObjectResult = this.obsClient.putObject(clientConfigurations.getBucketName(), clientConfigurations.getObjectName(), (InputStream)body);
        } else {
            throw new IllegalArgumentException("Body should be of type file, string or an input stream");
        }
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)putObjectResult));
    }

    private void getObject(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketName()) || ObjectHelper.isEmpty((String)clientConfigurations.getObjectName())) {
            throw new IllegalArgumentException("Bucket and object names are mandatory to get objects");
        }
        LOG.debug("Downloading remote obs object {} from bucket {}", (Object)clientConfigurations.getObjectName(), (Object)clientConfigurations.getBucketLocation());
        ObsObject obsObject = this.obsClient.getObject(clientConfigurations.getBucketName(), clientConfigurations.getObjectName());
        LOG.debug("Successfully downloaded obs object {}", (Object)clientConfigurations.getObjectName());
        OBSUtils.mapObsObject(exchange, obsObject);
    }

    private void listBuckets(Exchange exchange) throws ObsException {
        ListBucketsRequest request = new ListBucketsRequest();
        ListBucketsResult response = this.obsClient.listBucketsV2(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getBuckets()));
    }

    private void createBucket(Exchange exchange, ClientConfigurations clientConfigurations) throws ObsException {
        CreateBucketRequest request = null;
        Object exchangeBody = exchange.getMessage().getBody();
        if (exchangeBody instanceof CreateBucketRequest) {
            request = (CreateBucketRequest)exchangeBody;
        } else if (exchangeBody instanceof String) {
            String strBody = (String)exchangeBody;
            try {
                request = (CreateBucketRequest)new ObjectMapper().readValue(strBody, CreateBucketRequest.class);
            }
            catch (JsonProcessingException e) {
                LOG.warn("String request body must be a valid JSON representation of a CreateBucketRequest. Attempting to create a bucket from endpoint parameters");
            }
        }
        if (request == null) {
            if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketName())) {
                LOG.error("No bucket name given");
                throw new IllegalArgumentException("Bucket name is mandatory to create bucket");
            }
            if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketLocation())) {
                LOG.warn("No bucket location given, defaulting to '{}'", (Object)"cn-north-1");
                clientConfigurations.setBucketLocation("cn-north-1");
            }
            OBSRegion.checkValidRegion(clientConfigurations.getBucketLocation());
            request = new CreateBucketRequest(clientConfigurations.getBucketName(), clientConfigurations.getBucketLocation());
        }
        ObsBucket response = this.obsClient.createBucket(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response));
    }

    private void deleteBucket(Exchange exchange, ClientConfigurations clientConfigurations) throws ObsException {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketName())) {
            LOG.error("No bucket name given");
            throw new IllegalArgumentException("Bucket name is mandatory to delete bucket");
        }
        HeaderResponse response = this.obsClient.deleteBucket(clientConfigurations.getBucketName());
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response.getResponseHeaders()));
    }

    private void checkBucketExists(Exchange exchange, ClientConfigurations clientConfigurations) throws ObsException {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketName())) {
            LOG.error("No bucket name given");
            throw new IllegalArgumentException("Bucket name is mandatory to check if bucket exists");
        }
        boolean bucketExists = this.obsClient.headBucket(clientConfigurations.getBucketName());
        exchange.setProperty("CamelHwCloudObsBucketExists", (Object)bucketExists);
    }

    private void getBucketMetadata(Exchange exchange, ClientConfigurations clientConfigurations) throws ObsException {
        if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketName())) {
            LOG.error("No bucket name given");
            throw new IllegalArgumentException("Bucket name is mandatory to get bucket metadata");
        }
        BucketMetadataInfoRequest request = new BucketMetadataInfoRequest(clientConfigurations.getBucketName());
        BucketMetadataInfoResult response = this.obsClient.getBucketMetadata(request);
        exchange.getMessage().setBody((Object)this.gson.toJson((Object)response));
    }

    private void listObjects(Exchange exchange, ClientConfigurations clientConfigurations) throws ObsException {
        ObjectListing result;
        ListObjectsRequest request = null;
        Object exchangeBody = exchange.getMessage().getBody();
        if (exchangeBody instanceof ListObjectsRequest) {
            request = (ListObjectsRequest)exchangeBody;
        } else if (exchangeBody instanceof String) {
            String strBody = (String)exchangeBody;
            try {
                request = (ListObjectsRequest)new ObjectMapper().readValue(strBody, ListObjectsRequest.class);
            }
            catch (JsonProcessingException e) {
                LOG.warn("String request body must be a valid JSON representation of a ListObjectsRequest. Attempting to list objects from endpoint parameters");
            }
        }
        if (request == null) {
            if (ObjectHelper.isEmpty((String)clientConfigurations.getBucketName())) {
                LOG.error("No bucket name given");
                throw new IllegalArgumentException("Bucket name is mandatory to list objects");
            }
            request = new ListObjectsRequest(clientConfigurations.getBucketName());
        }
        ArrayList objects = new ArrayList();
        do {
            result = this.obsClient.listObjects(request);
            objects.addAll(result.getObjects());
            request.setMarker(result.getNextMarker());
        } while (result.isTruncated());
        exchange.getMessage().setBody((Object)this.gson.toJson(objects));
    }

    private void updateClientConfigs(Exchange exchange, ClientConfigurations clientConfigurations) {
        if (ObjectHelper.isEmpty((Object)exchange.getProperty("CamelHwCloudObsOperation")) && ObjectHelper.isEmpty((String)this.endpoint.getOperation())) {
            LOG.error("No operation name given. Cannot proceed with OBS operations.");
            throw new IllegalArgumentException("Operation name not found");
        }
        clientConfigurations.setOperation(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsOperation")) ? (String)exchange.getProperty("CamelHwCloudObsOperation") : this.endpoint.getOperation());
        if (ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsBucketName")) || ObjectHelper.isNotEmpty((String)this.endpoint.getBucketName())) {
            clientConfigurations.setBucketName(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsBucketName")) ? (String)exchange.getProperty("CamelHwCloudObsBucketName") : this.endpoint.getBucketName());
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsBucketLocation")) || ObjectHelper.isNotEmpty((String)this.endpoint.getBucketLocation())) {
            clientConfigurations.setBucketLocation(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsBucketLocation")) ? (String)exchange.getProperty("CamelHwCloudObsBucketLocation") : this.endpoint.getBucketLocation());
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsObjectName")) || ObjectHelper.isNotEmpty((String)this.endpoint.getObjectName())) {
            clientConfigurations.setObjectName(ObjectHelper.isNotEmpty((Object)exchange.getProperty("CamelHwCloudObsObjectName")) ? (String)exchange.getProperty("CamelHwCloudObsObjectName") : this.endpoint.getObjectName());
        }
    }
}

