/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.io.File;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Service;
import org.apache.camel.blueprint.BlueprintCamelContext;
import org.apache.camel.karaf.core.OsgiDefaultCamelContext;
import org.apache.karaf.camel.itests.CamelContextProvider;
import org.apache.karaf.camel.itests.CamelKarafTestHint;
import org.apache.karaf.camel.itests.DumpFileOnError;
import org.apache.karaf.camel.itests.PaxExamWithExternalResource;
import org.apache.karaf.camel.itests.TestContainerFactoryFailureAware;
import org.apache.karaf.camel.itests.Utils;
import org.apache.karaf.itests.KarafTestSupport;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamFactory;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.container.remote.RBCRemoteTargetOptions;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationFilePutOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExamFactory(value=TestContainerFactoryFailureAware.class)
public abstract class AbstractCamelRouteITest
extends KarafTestSupport
implements CamelContextProvider {
    public static final int CAMEL_KARAF_INTEGRATION_TEST_DEBUG_DEFAULT_PORT = 8889;
    public static final String CAMEL_KARAF_INTEGRATION_TEST_DEBUG_PROPERTY = "camel.karaf.itest.debug";
    static final int CAMEL_KARAF_INTEGRATION_TEST_CONTEXT_FINDER_RETRY_DEFAULT = 3;
    static final int CAMEL_KARAF_INTEGRATION_TEST_CONTEXT_FINDER_RETRY_INTERVAL_DEFAULT = 5;
    static final String CAMEL_KARAF_INTEGRATION_TEST_CONTEXT_FINDER_RETRY_PROPERTY = "camel.karaf.itest.context.finder.retry";
    static final String CAMEL_KARAF_INTEGRATION_TEST_CONTEXT_FINDER_RETRY_INTERVAL_PROPERTY = "camel.karaf.itest.context.finder.retry.interval";
    static final String CAMEL_KARAF_INTEGRATION_TEST_ROUTE_SUPPLIERS_PROPERTY = "camel.karaf.itest.route.suppliers";
    static final String CAMEL_KARAF_INTEGRATION_TEST_IGNORE_ROUTE_SUPPLIERS_PROPERTY = "camel.karaf.itest.ignore.route.suppliers";
    static final String CAMEL_KARAF_INTEGRATION_TEST_DUMP_LOGS_PROPERTY = "camel.karaf.itest.dump.logs";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelRouteITest.class);
    private final Map<CamelContextKey, CamelContext> contexts = new ConcurrentHashMap<CamelContextKey, CamelContext>();
    private final Map<CamelContextKey, ProducerTemplate> templates = new ConcurrentHashMap<CamelContextKey, ProducerTemplate>();
    @Rule
    public final DumpFileOnError dumpFileOnError;
    private List<String> requiredBundles;

    protected AbstractCamelRouteITest() {
        this.retry = new KarafTestSupport.Retry(this.retryOnFailure());
        this.dumpFileOnError = new DumpFileOnError(AbstractCamelRouteITest.getKarafLogFile(), System.err, Boolean.getBoolean(CAMEL_KARAF_INTEGRATION_TEST_DUMP_LOGS_PROPERTY));
    }

    public String getCamelKarafVersion() {
        String version = System.getProperty("camel.karaf.version");
        if (version == null) {
            version = Utils.loadCamelKarafVersion();
        }
        return version;
    }

    public String getBaseDir() {
        String location = System.getProperty("project.target");
        if (location == null) {
            throw new IllegalStateException("The system property 'project.target' must be set to the target directory of the project or the method getBaseDir must be overridden to provide the base directory");
        }
        return location;
    }

    public File getUsersFile() {
        String location = System.getProperty("users.file.location");
        if (location == null) {
            location = Utils.loadUsersFileIfAbsent(this.getBaseDir());
        }
        return new File(location);
    }

    public File getConfigFile(String path) {
        if (path.equals("/etc/users.properties")) {
            return this.getUsersFile();
        }
        return super.getConfigFile(path);
    }

    @Configuration
    public Option[] config() {
        String camelKarafVersion = this.getCamelKarafVersion();
        if (camelKarafVersion == null) {
            throw new IllegalArgumentException("The system property 'camel.karaf.version' must be set or the method getCamelKarafVersion must be overridden to provide the version of Camel Karaf to use");
        }
        Option[] options = new Option[]{CoreOptions.systemTimeout((long)this.timeoutInMillis()), RBCRemoteTargetOptions.waitForRBCFor((Integer)((int)this.timeoutInMillis())), CoreOptions.systemProperty((String)CAMEL_KARAF_INTEGRATION_TEST_DUMP_LOGS_PROPERTY).value(System.getProperty(CAMEL_KARAF_INTEGRATION_TEST_DUMP_LOGS_PROPERTY, "false")), CoreOptions.systemProperty((String)"project.target").value(this.getBaseDir()), KarafDistributionOption.features((String)"mvn:org.apache.camel.karaf/apache-camel/%s/xml/features".formatted(camelKarafVersion), (String[])new String[]{"scr", this.getMode().getFeatureName()}), CoreOptions.mavenBundle().groupId("org.apache.camel.karaf").artifactId("camel-integration-test").version(camelKarafVersion)};
        Option[] combine = OptionUtils.combine((Option[])AbstractCamelRouteITest.updatePorts(super.config()), (Option[])options);
        if (AbstractCamelRouteITest.isDebugModeEnabled()) {
            combine = OptionUtils.combine((Option[])combine, (Option[])new Option[]{KarafDistributionOption.debugConfiguration((String)Integer.toString(AbstractCamelRouteITest.getDebugPort()), (boolean)true)});
        }
        if (this.hasExternalResources()) {
            combine = OptionUtils.combine((Option[])combine, (Option[])AbstractCamelRouteITest.getExternalResourceOptions());
        }
        if (this.ignoreCamelRouteSuppliers()) {
            combine = OptionUtils.combine((Option[])combine, (Option[])new Option[]{this.getIgnoreCamelRouteSupplier()});
        } else if (this.hasCamelRouteSupplierFilter()) {
            combine = OptionUtils.combine((Option[])combine, (Option[])new Option[]{this.getCamelRouteSupplierFilter()});
        }
        return OptionUtils.combine((Option[])combine, (Option[])this.getAdditionalOptions());
    }

    @NotNull
    private static File getKarafLogFile() {
        return new File(System.getProperty("karaf.log"), "karaf.log");
    }

    private static boolean isDebugModeEnabled() {
        return System.getProperty(CAMEL_KARAF_INTEGRATION_TEST_DEBUG_PROPERTY) != null;
    }

    private static int getDebugPort() {
        return Integer.getInteger(CAMEL_KARAF_INTEGRATION_TEST_DEBUG_PROPERTY, 8889);
    }

    private static int getContextFinderRetry() {
        return Integer.getInteger(CAMEL_KARAF_INTEGRATION_TEST_CONTEXT_FINDER_RETRY_PROPERTY, 3);
    }

    private static int getContextFinderRetryInterval() {
        return Integer.getInteger(CAMEL_KARAF_INTEGRATION_TEST_CONTEXT_FINDER_RETRY_INTERVAL_PROPERTY, 5);
    }

    private static Option[] updatePorts(Option[] options) {
        for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            if (!(option instanceof KarafDistributionConfigurationFilePutOption)) continue;
            KarafDistributionConfigurationFilePutOption putOption = (KarafDistributionConfigurationFilePutOption)option;
            if (putOption.getConfigurationFilePath().equals("etc/org.ops4j.pax.web.cfg") && putOption.getKey().equals("org.osgi.service.http.port")) {
                String httpPort = Integer.toString(Utils.getAvailablePort(Integer.parseInt("9080"), Integer.parseInt("9999")));
                options[i] = KarafDistributionOption.editConfigurationFilePut((String)putOption.getConfigurationFilePath(), (String)putOption.getKey(), (Object)httpPort);
                continue;
            }
            if (putOption.getConfigurationFilePath().equals("etc/org.apache.karaf.management.cfg")) {
                if (putOption.getKey().equals("rmiRegistryPort")) {
                    String rmiRegistryPort = Integer.toString(Utils.getAvailablePort(Integer.parseInt("1099"), Integer.parseInt("9999")));
                    options[i] = KarafDistributionOption.editConfigurationFilePut((String)putOption.getConfigurationFilePath(), (String)putOption.getKey(), (Object)rmiRegistryPort);
                    continue;
                }
                if (!putOption.getKey().equals("rmiServerPort")) continue;
                String rmiServerPort = Integer.toString(Utils.getAvailablePort(Integer.parseInt("44444"), Integer.parseInt("65534")));
                options[i] = KarafDistributionOption.editConfigurationFilePut((String)putOption.getConfigurationFilePath(), (String)putOption.getKey(), (Object)rmiServerPort);
                continue;
            }
            if (!putOption.getConfigurationFilePath().equals("etc/org.apache.karaf.shell.cfg") || !putOption.getKey().equals("sshPort")) continue;
            String sshPort = Integer.toString(Utils.getAvailablePort(Integer.parseInt("8101"), Integer.parseInt("8888")));
            options[i] = KarafDistributionOption.editConfigurationFilePut((String)putOption.getConfigurationFilePath(), (String)putOption.getKey(), (Object)sshPort);
        }
        return options;
    }

    @NotNull
    private static Option[] getExternalResourceOptions() {
        return (Option[])PaxExamWithExternalResource.systemProperties().entrySet().stream().map(e -> CoreOptions.systemProperty((String)((String)e.getKey())).value((String)e.getValue())).toArray(Option[]::new);
    }

    private long timeoutInMillis() {
        return TimeUnit.SECONDS.toMillis(this.getCamelKarafTestHint().map(CamelKarafTestHint::timeout).orElse(300).intValue());
    }

    private boolean retryOnFailure() {
        return this.getCamelKarafTestHint().filter(CamelKarafTestHint::retryOnFailure).isPresent();
    }

    private boolean hasExternalResources() {
        return this.getCamelKarafTestHint().filter(hint -> hint.externalResourceProvider() != Object.class).isPresent();
    }

    private Optional<CamelKarafTestHint> getCamelKarafTestHint() {
        return AbstractCamelRouteITest.getCamelKarafTestHint(this.getClass());
    }

    private static Optional<CamelKarafTestHint> getCamelKarafTestHint(Class<?> clazz) {
        return Optional.ofNullable(clazz.getAnnotation(CamelKarafTestHint.class));
    }

    private Option getCamelRouteSupplierFilter() {
        return CoreOptions.systemProperty((String)CAMEL_KARAF_INTEGRATION_TEST_ROUTE_SUPPLIERS_PROPERTY).value(String.join((CharSequence)",", this.getCamelKarafTestHint().orElseThrow().camelRouteSuppliers()));
    }

    private boolean hasCamelRouteSupplierFilter() {
        return this.getCamelKarafTestHint().filter(hint -> hint.camelRouteSuppliers().length > 0).isPresent();
    }

    private boolean ignoreCamelRouteSuppliers() {
        return this.getCamelKarafTestHint().filter(CamelKarafTestHint::ignoreRouteSuppliers).isPresent();
    }

    private boolean hasAdditionalRequiredFeatures() {
        return this.getCamelKarafTestHint().filter(hint -> hint.additionalRequiredFeatures().length > 0).isPresent();
    }

    private Option getIgnoreCamelRouteSupplier() {
        return CoreOptions.systemProperty((String)CAMEL_KARAF_INTEGRATION_TEST_IGNORE_ROUTE_SUPPLIERS_PROPERTY).value(Boolean.toString(Boolean.TRUE));
    }

    protected Option[] getAdditionalOptions() {
        return new Option[0];
    }

    @Before
    public final void init() throws Exception {
        this.installRequiredFeaturesRepositories();
        this.installRequiredFeatures();
        this.requiredBundles = this.installRequiredBundles();
    }

    protected List<String> getRequiredFeaturesRepositories() {
        return List.of();
    }

    private void installRequiredFeaturesRepositories() throws Exception {
        for (String featuresRepository : this.getRequiredFeaturesRepositories()) {
            this.addFeaturesRepository(featuresRepository);
        }
    }

    protected abstract List<String> getRequiredFeatures();

    private List<String> getAllRequiredFeatures() {
        if (this.hasAdditionalRequiredFeatures()) {
            ArrayList<String> requiredFeatures = new ArrayList<String>(this.getRequiredFeatures());
            requiredFeatures.addAll(List.of(this.getCamelKarafTestHint().orElseThrow().additionalRequiredFeatures()));
            return requiredFeatures;
        }
        return this.getRequiredFeatures();
    }

    private void installRequiredFeatures() throws Exception {
        for (String featureName : this.getAllRequiredFeatures()) {
            if (this.featureService.getFeature(featureName) == null) {
                throw new IllegalArgumentException("Feature %s is not available".formatted(featureName));
            }
            this.installAndAssertFeature(featureName);
        }
    }

    protected List<String> installRequiredBundles() throws Exception {
        return List.of();
    }

    private static boolean isBlueprintTest(Class<?> clazz) {
        return AbstractCamelRouteITest.getCamelKarafTestHint(clazz).filter(CamelKarafTestHint::isBlueprintTest).isPresent();
    }

    private static Mode getMode(Class<?> clazz) {
        return AbstractCamelRouteITest.getMode(AbstractCamelRouteITest.isBlueprintTest(clazz));
    }

    private static Mode getMode(boolean blueprint) {
        return blueprint ? Mode.BLUEPRINT : Mode.CORE;
    }

    private Mode getMode() {
        return AbstractCamelRouteITest.getMode(this.getClass());
    }

    @After
    public final void destroy() {
        this.destroyProducerTemplates();
        this.uninstallRequiredBundles();
        this.uninstallRequiredFeatures();
        this.removeRequiredFeaturesRepositories();
    }

    private void uninstallRequiredBundles() {
        if (this.requiredBundles == null) {
            return;
        }
        for (String bundleName : this.requiredBundles) {
            try {
                this.uninstallBundle(bundleName);
            }
            catch (Exception e) {
                LOG.warn("Error while uninstalling bundle {}", (Object)bundleName, (Object)e);
            }
        }
    }

    private void uninstallBundle(String bundleName) {
        Bundle bundle = this.findBundleByName(bundleName);
        if (bundle == null) {
            return;
        }
        try {
            bundle.uninstall();
        }
        catch (BundleException e) {
            LOG.warn("Error while uninstalling bundle {}", (Object)bundleName, (Object)e);
        }
    }

    private void uninstallRequiredFeatures() {
        for (String featureName : this.getAllRequiredFeatures()) {
            try {
                this.featureService.uninstallFeature(featureName);
            }
            catch (Exception e) {
                LOG.warn("Error while uninstalling feature {}", (Object)featureName, (Object)e);
            }
        }
    }

    private void removeRequiredFeaturesRepositories() {
        for (String featuresRepository : this.getRequiredFeaturesRepositories()) {
            try {
                this.featureService.removeRepository(new URI(featuresRepository));
            }
            catch (Exception e) {
                LOG.warn("Error while removing features repository {}", (Object)featuresRepository, (Object)e);
            }
        }
    }

    private void destroyProducerTemplates() {
        this.templates.values().forEach(Service::stop);
        this.templates.clear();
    }

    protected void assertBundleInstalledAndRunning(String name) {
        Bundle bundle = this.findBundleByName(name);
        Assert.assertNotNull((String)"Bundle %s should be installed".formatted(name), (Object)bundle);
        Assert.assertEquals((long)32L, (long)bundle.getState());
        String bundles = this.executeCommand("bundle:list -s -t 0 | grep %s".formatted(name), this.timeoutInMillis(), false, new Principal[0]);
        Assert.assertTrue((String)"bundle %s is in state %d /%s".formatted(bundle.getSymbolicName(), bundle.getState(), bundles), (boolean)bundles.contains("Active"));
    }

    @Override
    public CamelContext getContext(Class<?> clazz) {
        return this.contexts.computeIfAbsent(new CamelContextKey(clazz), key -> {
            try {
                return AbstractCamelRouteITest.getMode(clazz).getCamelContextClass(this.bundleContext, key.getCamelContextName());
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("No CamelContext could be found matching the criteria", e);
            }
        });
    }

    @Override
    public ProducerTemplate getTemplate(Class<?> clazz) {
        return this.templates.computeIfAbsent(new CamelContextKey(clazz), key -> {
            ProducerTemplate template = this.getContext(clazz).createProducerTemplate();
            template.start();
            return template;
        });
    }

    @Override
    public CamelContext getContext(String name, boolean isBlueprintTest) {
        return this.contexts.computeIfAbsent(new CamelContextKey(name, isBlueprintTest), key -> {
            try {
                return AbstractCamelRouteITest.getMode(isBlueprintTest).getCamelContextClass(this.bundleContext, key.getCamelContextName());
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("No CamelContext could be found matching the criteria", e);
            }
        });
    }

    @Override
    public ProducerTemplate getTemplate(String name, boolean isBlueprintTest) {
        return this.templates.computeIfAbsent(new CamelContextKey(name, isBlueprintTest), key -> {
            ProducerTemplate template = this.getContext(name, isBlueprintTest).createProducerTemplate();
            template.start();
            return template;
        });
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Mode {
        BLUEPRINT{

            @Override
            String getFeatureName() {
                return "camel-blueprint";
            }

            @Override
            Class<? extends CamelContext> getCamelContextClass() {
                return BlueprintCamelContext.class;
            }
        }
        ,
        CORE{

            @Override
            String getFeatureName() {
                return "camel-core";
            }

            @Override
            Class<? extends CamelContext> getCamelContextClass() {
                return OsgiDefaultCamelContext.class;
            }
        };


        abstract String getFeatureName();

        abstract Class<? extends CamelContext> getCamelContextClass();

        CamelContext getCamelContextClass(BundleContext bundleContext, String name) throws InvalidSyntaxException {
            for (int i = 0; i < AbstractCamelRouteITest.getContextFinderRetry(); ++i) {
                CamelContext camelContext = this.findCamelContext(bundleContext, name);
                if (camelContext != null) {
                    return camelContext;
                }
                LOG.warn("No CamelContext could be found matching the criteria (mode = {}, name = {}), retrying in {} seconds", new Object[]{this, name, AbstractCamelRouteITest.getContextFinderRetryInterval()});
                try {
                    Thread.sleep((long)AbstractCamelRouteITest.getContextFinderRetryInterval() * 1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new IllegalStateException("No CamelContext could be found matching the criteria (mode = " + this + ", name = " + name + ")");
        }

        private CamelContext findCamelContext(BundleContext bundleContext, String name) throws InvalidSyntaxException {
            ServiceReference[] references = bundleContext.getServiceReferences(CamelContext.class.getName(), null);
            if (references == null) {
                return null;
            }
            for (ServiceReference reference : references) {
                CamelContext camelContext;
                if (reference == null || !(camelContext = (CamelContext)bundleContext.getService(reference)).getClass().equals(this.getCamelContextClass()) || name != null && !name.equals(camelContext.getName())) continue;
                return camelContext;
            }
            return null;
        }
    }

    private static class CamelContextKey {
        private final String name;
        private final boolean blueprint;

        CamelContextKey(String name, boolean blueprint) {
            this.name = name;
            this.blueprint = blueprint;
        }

        CamelContextKey(Class<?> clazz) {
            this(Utils.getCamelContextName(clazz), AbstractCamelRouteITest.isBlueprintTest(clazz));
        }

        public String getCamelContextName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CamelContextKey that = (CamelContextKey)o;
            return this.blueprint == that.blueprint && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.blueprint);
        }
    }
}

