/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.karaf.core.OsgiCamelContextPublisher;
import org.apache.camel.karaf.core.OsgiDefaultCamelContext;
import org.apache.karaf.camel.itests.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

public abstract class AbstractCamelRouteLauncher {
    protected OsgiDefaultCamelContext camelContext;
    protected ServiceRegistration<?> serviceRegistration;

    @Activate
    public void activate(ComponentContext componentContext) throws Exception {
        BundleContext bundleContext = componentContext.getBundleContext();
        this.camelContext = new OsgiDefaultCamelContext(bundleContext);
        String contextName = Utils.getCamelContextName(this.getClass());
        if (contextName == null) {
            throw new IllegalStateException("Camel context name not set for " + this.getClass().getName() + " using @CamelKarafTestHint annotation");
        }
        this.camelContext.getCamelContextExtension().setName(contextName);
        this.serviceRegistration = new OsgiCamelContextPublisher(bundleContext).registerCamelContext((CamelContext)this.camelContext);
        if (this.serviceRegistration == null) {
            throw new IllegalStateException("Camel context registration failed for " + contextName + " most likely because the context name is already in use");
        }
        this.camelContext.start();
        this.camelContext.addRoutes((RoutesBuilder)this.createRouteBuilder());
    }

    @Deactivate
    public void deactivate() {
        if (this.camelContext == null) {
            return;
        }
        this.camelContext.stop();
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    protected abstract RouteBuilder createRouteBuilder();
}

