/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.karaf.camel.itests.AbstractCamelRouteITest;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;

public abstract class AbstractCamelRouteWithBundleITest
extends AbstractCamelRouteITest {
    protected abstract String getTestBundleName();

    public String getTestBundleVersion() {
        return System.getProperty("project.version");
    }

    @Override
    protected List<String> installRequiredBundles() throws Exception {
        String testBundleName = this.getTestBundleName();
        String testBundleVersion = this.getTestBundleVersion();
        if (testBundleVersion == null) {
            throw new IllegalArgumentException("The system property project.version must be set to the version of the test bundle to install or the method getTestBundleVersion must be overridden to provide the version");
        }
        Path bundlePath = Paths.get("%s/%s-%s.jar".formatted(this.getBaseDir(), testBundleName, testBundleVersion), new String[0]);
        this.installBundle(bundlePath.toUri().toString(), true);
        this.assertBundleInstalledAndRunning(testBundleName);
        return List.of(testBundleName);
    }

    @Override
    protected Option[] getAdditionalOptions() {
        return OptionUtils.combine((Option[])super.getAdditionalOptions(), (Option[])new Option[]{CoreOptions.systemProperty((String)"project.version").value(this.getTestBundleVersion())});
    }
}

