/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.camel.itests;

import java.util.function.Function;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.karaf.camel.itests.CamelRouteSupplier;
import org.apache.karaf.camel.itests.Utils;

public abstract class AbstractCamelSingleFeatureRouteSupplier
implements CamelRouteSupplier {
    public String getTestComponentName() {
        String name = Utils.toKebabCase(this.getClass().getSimpleName());
        if (!name.endsWith("-route-supplier")) {
            throw new IllegalArgumentException("The route supplier class name doesn't match with the expected format: <tested-camel-component-name>RouteSupplier");
        }
        return name.replace("-route-supplier", "-test");
    }

    @Override
    public void createRoutes(RouteBuilder builder) {
        if (this.producerEnabled()) {
            this.configureProducer(builder, builder.fromF("direct:%s", new Object[]{this.getTestComponentName()}).routeId("producer-%s".formatted(this.getTestComponentName())));
        }
        if (this.consumerEnabled()) {
            this.configureConsumer(this.consumerRoute().apply(builder));
        }
    }

    protected boolean producerEnabled() {
        return true;
    }

    protected boolean consumerEnabled() {
        return true;
    }

    protected Function<RouteBuilder, RouteDefinition> consumerRoute() {
        return null;
    }

    protected void configureProducer(RouteBuilder builder, RouteDefinition producerRoute) {
    }

    protected void configureConsumer(RouteDefinition consumerRoute) {
        if (consumerRoute.hasCustomIdAssigned()) {
            return;
        }
        consumerRoute.routeId("consumer-%s".formatted(this.getTestComponentName()));
    }
}

